/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.excessive_building.datagen.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import net.yirmiri.excessive_building.EBConfig;
import org.jetbrains.annotations.NotNull;

public class AddLootModifier
extends LootModifier {
    public static final Supplier<Codec<AddLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> AddLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ForgeRegistries.BLOCKS.getCodec().fieldOf("block").forGetter(m -> m.block)).apply((Applicative)inst, AddLootModifier::new)));
    private final Block block;

    public AddLootModifier(LootItemCondition[] conditionsIn, Block block) {
        super(conditionsIn);
        this.block = block;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (((Boolean)EBConfig.ENABLE_EB_LOOT_MODIFIERS.get()).booleanValue()) {
            for (LootItemCondition condition : this.conditions) {
                if (condition.test((Object)context)) continue;
                return generatedLoot;
            }
        }
        generatedLoot.add((Object)new ItemStack((ItemLike)this.block));
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

