/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.jearchaeology.jei;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import cy.jdkdigital.jearchaeology.compat.CompatHandler;
import cy.jdkdigital.jearchaeology.jei.JeiPlugin;
import cy.jdkdigital.jearchaeology.recipe.BrushingRecipe;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import org.jetbrains.annotations.NotNull;

public class BrushRecipeCategory
implements IRecipeCategory<BrushingRecipe> {
    private static final UUID BRUSHER_PLAYER_UUID = UUID.nameUUIDFromBytes("jea_brusher_player".getBytes(StandardCharsets.UTF_8));
    private static List<BrushingRecipe> cachedRecipes = new ArrayList<BrushingRecipe>();
    private final IDrawable background;
    private final IDrawable icon;

    public BrushRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(126, 70);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Items.f_271356_));
    }

    public static List<BrushingRecipe> getAllRecipes(ServerLevel level) {
        if (level != null && cachedRecipes.isEmpty()) {
            ArrayList<BrushingRecipe> recipeList = new ArrayList<BrushingRecipe>();
            Map<ResourceLocation, Pair<String, Ingredient>> tables = CompatHandler.getTables();
            FakePlayer fakePlayer = FakePlayerFactory.get((ServerLevel)level, (GameProfile)new GameProfile(BRUSHER_PLAYER_UUID, "jea_brusher_player"));
            LootParams lootparams = new LootParams.Builder(level).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)new BlockPos(0, 0, 0))).m_287239_(1.0f).m_287286_(LootContextParams.f_81455_, (Object)fakePlayer).m_287235_(LootContextParamSets.f_81411_);
            tables.forEach((resourceLocation, pair) -> {
                HashMap items = new HashMap();
                LootTable table = level.m_7654_().m_278653_().m_278676_(resourceLocation);
                if (!table.equals(LootTable.f_79105_)) {
                    for (int i = 0; i < 600; ++i) {
                        table.m_287195_(lootparams).forEach(itemStack -> {
                            if (!items.containsKey(itemStack.m_41720_())) {
                                items.put(itemStack.m_41720_(), itemStack);
                            }
                        });
                    }
                }
                String locationName = (String)pair.getFirst();
                if (items.size() > 42) {
                    recipeList.add(new BrushingRecipe(new ResourceLocation("jearchaeology", locationName), Ingredient.m_43927_((ItemStack[])items.values().stream().limit(42L).toList().toArray(new ItemStack[0])), 1.0, (Ingredient)pair.getSecond()));
                    recipeList.add(new BrushingRecipe(new ResourceLocation("jearchaeology", locationName), Ingredient.m_43927_((ItemStack[])items.values().stream().skip(42L).toList().toArray(new ItemStack[0])), 1.0, (Ingredient)pair.getSecond()));
                } else if (items.size() > 21) {
                    recipeList.add(new BrushingRecipe(new ResourceLocation("jearchaeology", locationName), Ingredient.m_43927_((ItemStack[])items.values().stream().limit(21L).toList().toArray(new ItemStack[0])), 1.0, (Ingredient)pair.getSecond()));
                    recipeList.add(new BrushingRecipe(new ResourceLocation("jearchaeology", locationName), Ingredient.m_43927_((ItemStack[])items.values().stream().skip(21L).toList().toArray(new ItemStack[0])), 1.0, (Ingredient)pair.getSecond()));
                } else {
                    recipeList.add(new BrushingRecipe(new ResourceLocation("jearchaeology", locationName), Ingredient.m_43927_((ItemStack[])items.values().toArray(new ItemStack[0])), 1.0, (Ingredient)pair.getSecond()));
                }
            });
            BrushRecipeCategory.setRecipes(recipeList);
        }
        return cachedRecipes;
    }

    public static void setRecipes(List<BrushingRecipe> data) {
        cachedRecipes = data;
    }

    @NotNull
    public RecipeType<BrushingRecipe> getRecipeType() {
        return JeiPlugin.BRUSH_RECIPE_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.m_237115_((String)"jearchaeology.recipe.brush");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BrushingRecipe recipe, @NotNull IFocusGroup iFocusGroup) {
        AtomicInteger i = new AtomicInteger();
        Arrays.stream(recipe.item.m_43908_()).forEach(itemStack -> {
            int row = (int)Math.floor((float)i.get() / 7.0f);
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, (i.get() - row * 7) * 18, row * 18).addItemStack(itemStack)).setSlotName("thing" + i);
            i.set(i.get() + 1);
        });
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 0, 56).addIngredients(recipe.brushableBlock)).setSlotName("sussy_block");
    }

    public void draw(BrushingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        guiGraphics.m_280649_(minecraft.f_91062_, Language.m_128107_().m_5536_((FormattedText)Component.m_237115_((String)("jearchaeology.brush.structure." + recipe.m_6423_().m_135815_()))), 22, 60, -16777216, false);
    }
}

