/*
 * Decompiled with CFR 0.152.
 */
package com.craisinlord.idas.state;

import com.craisinlord.idas.IDAS;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;

public class stateRegion {
    private final String regionKey;
    private final File regionFile;
    private final ConcurrentHashMap<Long, Boolean> stateMap = new ConcurrentHashMap();

    public stateRegion(Path basePath, String regionKey) {
        this.regionKey = regionKey;
        this.regionFile = basePath.resolve(regionKey).toFile();
        this.createRegionFileIfDoesNotExist();
    }

    public synchronized void setCleared(BlockPos pos, boolean isCleared) {
        this.stateMap.put(pos.m_121878_(), isCleared);
        this.createRegionFileIfDoesNotExist();
        CompoundTag compoundTag = this.readRegionFile();
        compoundTag.m_128379_(pos.toString(), isCleared);
        this.writeRegionFile(compoundTag);
    }

    public synchronized boolean isCleared(BlockPos pos) {
        long posAsLong = pos.m_121878_();
        if (this.stateMap.containsKey(posAsLong)) {
            return this.stateMap.get(posAsLong);
        }
        this.createRegionFileIfDoesNotExist();
        boolean isCleared = false;
        CompoundTag compoundTag = this.readRegionFile();
        if (compoundTag == null) {
            compoundTag = new CompoundTag();
            compoundTag.m_128379_(pos.toString(), isCleared);
            this.writeRegionFile(compoundTag);
        } else if (compoundTag.m_128441_(pos.toString())) {
            isCleared = compoundTag.m_128471_(pos.toString());
        } else {
            compoundTag.m_128379_(pos.toString(), isCleared);
            this.writeRegionFile(compoundTag);
        }
        this.stateMap.put(posAsLong, isCleared);
        return isCleared;
    }

    public synchronized void reset() {
        this.stateMap.clear();
    }

    private void writeRegionFile(CompoundTag compoundTag) {
        try {
            NbtIo.m_128955_((CompoundTag)compoundTag, (File)this.regionFile);
        }
        catch (IOException e) {
            IDAS.LOGGER.error("Encountered error writing data to Labyrinth region file {}", (Object)this.regionKey);
            IDAS.LOGGER.error((Object)e);
        }
    }

    private CompoundTag readRegionFile() {
        try {
            return NbtIo.m_128953_((File)this.regionFile);
        }
        catch (IOException e) {
            IDAS.LOGGER.error("Encountered error reading data from Labyrinth region file {}", (Object)this.regionKey);
            IDAS.LOGGER.error((Object)e);
            return new CompoundTag();
        }
    }

    private synchronized void createRegionFileIfDoesNotExist() {
        if (!this.regionFile.exists()) {
            try {
                this.regionFile.createNewFile();
                NbtIo.m_128955_((CompoundTag)new CompoundTag(), (File)this.regionFile);
            }
            catch (IOException e) {
                IDAS.LOGGER.error("Unable to create region file for region {}", (Object)this.regionKey);
                IDAS.LOGGER.error((Object)e);
            }
        }
    }
}

