/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.tile.util;

import net.blay09.mods.cookingforblockheads.menu.IContainerWithDoor;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;

public class DoorAnimator {
    private final BlockEntity blockEntity;
    private final int eventNumPlayers;
    private final int eventForcedOpen;
    private float angle;
    private float prevAngle;
    private int numPlayersUsing;
    private int ticksSinceSync;
    private SoundEvent soundEventOpen;
    private SoundEvent soundEventClose;
    private float openRadius = 2.5f;
    private boolean isForcedOpen;

    public DoorAnimator(BlockEntity tileEntity, int eventNumPlayers, int eventForcedOpen) {
        this.blockEntity = tileEntity;
        this.eventNumPlayers = eventNumPlayers;
        this.eventForcedOpen = eventForcedOpen;
    }

    public void setSoundEventOpen(SoundEvent soundEventOpen) {
        this.soundEventOpen = soundEventOpen;
    }

    public void setSoundEventClose(SoundEvent soundEventClose) {
        this.soundEventClose = soundEventClose;
    }

    public void setOpenRadius(float openRadius) {
        this.openRadius = openRadius;
    }

    public void update() {
        ++this.ticksSinceSync;
        int x = this.blockEntity.m_58899_().m_123341_();
        int y = this.blockEntity.m_58899_().m_123342_();
        int z = this.blockEntity.m_58899_().m_123343_();
        if (!this.blockEntity.m_58904_().f_46443_ && this.numPlayersUsing != 0 && (this.ticksSinceSync + x + y + z) % 200 == 0) {
            this.numPlayersUsing = 0;
            float range = 5.0f;
            for (Player player : this.blockEntity.m_58904_().m_45976_(Player.class, new AABB((double)((float)x - range), (double)((float)y - range), (double)((float)z - range), (double)((float)(x + 1) + range), (double)((float)(y + 1) + range), (double)((float)(z + 1) + range)))) {
                if (!(player.f_36096_ instanceof IContainerWithDoor) || !((IContainerWithDoor)player.f_36096_).isTileEntity(this.blockEntity)) continue;
                ++this.numPlayersUsing;
            }
        }
        this.prevAngle = this.angle;
        if ((this.isForcedOpen || this.numPlayersUsing > 0) && this.angle == 0.0f && this.soundEventOpen != null) {
            this.blockEntity.m_58904_().m_7785_((double)x, (double)y, (double)z, this.soundEventOpen, SoundSource.BLOCKS, 0.5f, this.blockEntity.m_58904_().f_46441_.m_188501_() * 0.1f + 0.9f, false);
        }
        float angleSpeed = 0.1f;
        if ((this.numPlayersUsing == 0 || !this.isForcedOpen) && this.angle > 0.0f || (this.isForcedOpen || this.numPlayersUsing > 0) && this.angle < 1.0f) {
            float angleBefore = this.angle;
            this.angle = this.numPlayersUsing > 0 || this.isForcedOpen ? (this.angle += angleSpeed) : (this.angle -= angleSpeed);
            this.angle = Math.min(this.angle, 1.0f);
            float playCloseSound = 0.5f;
            if (this.angle < playCloseSound && angleBefore >= playCloseSound && this.soundEventClose != null) {
                this.blockEntity.m_58904_().m_7785_((double)x, (double)y, (double)z, this.soundEventClose, SoundSource.BLOCKS, 0.5f, this.blockEntity.m_58904_().f_46441_.m_188501_() * 0.1f + 0.9f, false);
            }
            this.angle = Math.max(this.angle, 0.0f);
        }
    }

    public void toggleForcedOpen() {
        this.setForcedOpen(!this.isForcedOpen);
    }

    public boolean isForcedOpen() {
        return this.isForcedOpen;
    }

    public void setForcedOpen(boolean isForcedOpen) {
        this.isForcedOpen = isForcedOpen;
        Level level = this.blockEntity.m_58904_();
        if (level != null) {
            level.m_7696_(this.blockEntity.m_58899_(), this.blockEntity.m_58900_().m_60734_(), 2, isForcedOpen ? 1 : 0);
        }
    }

    public boolean receiveClientEvent(int id, int type) {
        if (id == this.eventNumPlayers) {
            this.numPlayersUsing = type;
            return true;
        }
        if (id == this.eventForcedOpen) {
            this.isForcedOpen = type == 1;
            return true;
        }
        return false;
    }

    public void openContainer(Player player) {
        if (!player.m_5833_()) {
            this.numPlayersUsing = Math.max(0, this.numPlayersUsing + 1);
            this.fireBlockEvent();
        }
    }

    public void closeContainer(Player player) {
        if (!player.m_5833_()) {
            --this.numPlayersUsing;
            this.fireBlockEvent();
        }
    }

    private void fireBlockEvent() {
        Level level = this.blockEntity.m_58904_();
        Block block = this.blockEntity.m_58900_().m_60734_();
        if (level != null) {
            level.m_7696_(this.blockEntity.m_58899_(), block, this.eventNumPlayers, this.numPlayersUsing);
            level.m_46672_(this.blockEntity.m_58899_(), block);
            level.m_46672_(this.blockEntity.m_58899_().m_7495_(), block);
        }
    }

    public float getRenderAngle(float partialTicks) {
        float renderAngle = this.prevAngle + (this.angle - this.prevAngle) * partialTicks;
        renderAngle = 1.0f - renderAngle;
        renderAngle = 1.0f - renderAngle * renderAngle * renderAngle;
        return (float)(Math.PI / (double)this.openRadius * (double)renderAngle);
    }

    public int getNumPlayersUsing() {
        return this.numPlayersUsing;
    }

    public void setNumPlayersUsing(int numPlayersUsing) {
        this.numPlayersUsing = numPlayersUsing;
    }
}

