/*
 * Decompiled with CFR 0.152.
 */
package elocindev.geckoanimfix.mixin.common;

import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoModel;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationProcessor;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.util.RenderUtils;

@Mixin(value={GeoModel.class}, remap=false)
public abstract class GeoModelMixin<T extends GeoAnimatable>
implements CoreGeoModel<T> {
    private long lastRenderedInstance = -1L;
    @Shadow
    private double animTime;
    @Shadow
    private double lastGameTickTime;

    @Shadow
    abstract boolean crashIfBoneMissing();

    @Overwrite
    public final void handleAnimations(T animatable, long instanceId, AnimationState<T> animationState) {
        boolean isReRender;
        Minecraft mc = Minecraft.m_91087_();
        AnimatableManager animatableManager = animatable.getAnimatableInstanceCache().getManagerForId(instanceId);
        Double currentTick = (Double)animationState.getData(DataTickets.TICK);
        if (currentTick == null) {
            double d;
            if (animatable instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)animatable;
                d = livingEntity.f_19797_;
            } else {
                d = RenderUtils.getCurrentTick();
            }
            currentTick = d;
        }
        if (animatableManager.getFirstTickTime() == -1.0) {
            animatableManager.startedAt(currentTick + (double)mc.m_91296_());
        }
        double currentFrameTime = currentTick - animatableManager.getFirstTickTime();
        boolean bl = isReRender = !animatableManager.isFirstTick() && currentFrameTime == animatableManager.getLastUpdateTime();
        if (isReRender && instanceId == this.lastRenderedInstance) {
            return;
        }
        if (!(isReRender || mc.m_91104_() && !animatable.shouldPlayAnimsWhileGamePaused())) {
            if (animatable instanceof LivingEntity) {
                animatableManager.updatedAt(currentFrameTime);
            } else {
                animatableManager.updatedAt(currentFrameTime);
            }
            double lastUpdateTime = animatableManager.getLastUpdateTime();
            this.animTime += lastUpdateTime - this.lastGameTickTime;
            this.lastGameTickTime = lastUpdateTime;
        }
        animationState.animationTick = this.animTime;
        AnimationProcessor processor = this.getAnimationProcessor();
        processor.preAnimationSetup(animationState.getAnimatable(), this.animTime);
        if (!processor.getRegisteredBones().isEmpty()) {
            processor.tickAnimation(animatable, (CoreGeoModel)this, animatableManager, this.animTime, animationState, this.crashIfBoneMissing());
        }
        this.setCustomAnimations((GeoAnimatable)animatable, instanceId, (AnimationState)animationState);
    }
}

