/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.arseng.item;

import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.StorageCell;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.upgrades.Upgrades;
import appeng.items.storage.StorageTier;
import appeng.items.tools.powered.AbstractPortableCell;
import appeng.menu.me.common.MEStorageMenu;
import gripe._90.arseng.ArsEnergistique;
import gripe._90.arseng.definition.ArsEngItems;
import gripe._90.arseng.me.cell.ISourceCellItem;
import gripe._90.arseng.me.cell.SourceCellHandler;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import org.jetbrains.annotations.NotNull;

public class PortableSourceCellItem
extends AbstractPortableCell
implements ISourceCellItem {
    private final StorageTier tier;

    public PortableSourceCellItem(Item.Properties props, StorageTier tier) {
        super(MEStorageMenu.PORTABLE_FLUID_CELL_TYPE, props, 0xFFFFFF);
        this.tier = tier;
    }

    public StorageTier getTier() {
        return this.tier;
    }

    @Override
    public long getTotalBytes() {
        return 50L * (long)Math.pow(4.0, this.tier.index() - 1);
    }

    @Override
    public double getIdleDrain() {
        return this.tier.idleDrain();
    }

    public ResourceLocation getRecipeId() {
        return ArsEnergistique.makeId(Objects.requireNonNull(this.getRegistryName()).m_135815_());
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> lines, TooltipFlag advancedTooltips) {
        super.m_7373_(stack, level, lines, advancedTooltips);
        SourceCellHandler.INSTANCE.addCellInformationToTooltip(stack, lines);
    }

    @NotNull
    public Optional<TooltipComponent> m_142422_(@NotNull ItemStack stack) {
        return SourceCellHandler.INSTANCE.getTooltipImage(stack);
    }

    public double getChargeRate(ItemStack stack) {
        return 80.0 * (double)(Upgrades.getEnergyCardMultiplier((IUpgradeInventory)this.getUpgrades(stack)) + 1);
    }

    public IUpgradeInventory getUpgrades(ItemStack is) {
        return UpgradeInventories.forItem((ItemStack)is, (int)3, (arg_0, arg_1) -> ((PortableSourceCellItem)this).onUpgradesChanged(arg_0, arg_1));
    }

    public static void initColours(RegisterColorHandlersEvent.Item event) {
        ArsEngItems.getPortables().forEach(portable -> event.register(PortableSourceCellItem::getColor, new ItemLike[]{portable}));
    }

    public static int getColor(ItemStack stack, int tintIndex) {
        Item item;
        if (tintIndex == 1 && (item = stack.m_41720_()) instanceof PortableSourceCellItem) {
            PortableSourceCellItem sourceCell = (PortableSourceCellItem)item;
            if (sourceCell.getAECurrentPower(stack) <= 0.0) {
                return CellState.ABSENT.getStateColor();
            }
            StorageCell cellInv = StorageCells.getCellInventory((ItemStack)stack, null);
            CellState cellStatus = cellInv != null ? cellInv.getStatus() : CellState.EMPTY;
            return cellStatus.getStateColor();
        }
        return 0xFFFFFF;
    }
}

