/*
 * Decompiled with CFR 0.152.
 */
package com.ofek2608.crafting_on_a_stick.integration;

import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class COASCurios {
    private static final String MODID = "curios";
    private static final String SLOT_ID = "crafting_on_a_stick";

    public static void load() {
    }

    public static boolean hasMod() {
        return ModList.get().isLoaded(MODID);
    }

    public static Optional<IItemHandlerModifiable> getCuriosInventory(Player player) {
        if (COASCurios.hasMod()) {
            return Integrator.getCuriosInventory(player);
        }
        return Optional.empty();
    }

    public static IItemHandlerModifiable getFullInventory(Player player) {
        PlayerInvWrapper inventory = new PlayerInvWrapper(player.m_150109_());
        Optional<IItemHandlerModifiable> curios = COASCurios.getCuriosInventory(player);
        return curios.isEmpty() ? inventory : new CombinedInvWrapper(new IItemHandlerModifiable[]{inventory, curios.get()});
    }

    private static final class Integrator {
        private Integrator() {
        }

        private static Optional<IItemHandlerModifiable> getCuriosInventory(Player player) {
            Optional itemHandler = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).resolve();
            if (itemHandler.isEmpty()) {
                return Optional.empty();
            }
            Optional stackHandler = ((ICuriosItemHandler)itemHandler.get()).getStacksHandler(COASCurios.SLOT_ID);
            return stackHandler.map(ICurioStacksHandler::getStacks);
        }
    }
}

