/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.paint;

import appeng.block.paint.PaintSplotches;
import appeng.blockentity.misc.PaintSplotchesBlockEntity;
import appeng.client.render.cablebus.CubeBuilder;
import appeng.helpers.Splotch;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

class PaintSplotchesBakedModel
implements IDynamicBakedModel {
    private static final Material TEXTURE_PAINT1 = new Material(TextureAtlas.f_118259_, new ResourceLocation("ae2", "block/paint1"));
    private static final Material TEXTURE_PAINT2 = new Material(TextureAtlas.f_118259_, new ResourceLocation("ae2", "block/paint2"));
    private static final Material TEXTURE_PAINT3 = new Material(TextureAtlas.f_118259_, new ResourceLocation("ae2", "block/paint3"));
    private final TextureAtlasSprite[] textures;

    PaintSplotchesBakedModel(Function<Material, TextureAtlasSprite> bakedTextureGetter) {
        this.textures = new TextureAtlasSprite[]{bakedTextureGetter.apply(TEXTURE_PAINT1), bakedTextureGetter.apply(TEXTURE_PAINT2), bakedTextureGetter.apply(TEXTURE_PAINT3)};
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, RenderType renderType) {
        if (side != null) {
            return Collections.emptyList();
        }
        PaintSplotches splotchesState = (PaintSplotches)extraData.get(PaintSplotchesBlockEntity.SPLOTCHES);
        if (splotchesState == null) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(1);
            CubeBuilder builder = new CubeBuilder(quads);
            builder.setTexture(this.textures[0]);
            builder.addCube(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f);
            return quads;
        }
        List<Splotch> splotches = splotchesState.getSplotches();
        CubeBuilder builder = new CubeBuilder();
        float offsetConstant = 0.001f;
        for (Splotch s : splotches) {
            if (s.isLumen()) {
                builder.setColorRGB(s.getColor().whiteVariant);
                builder.setEmissiveMaterial(true);
            } else {
                builder.setColorRGB(s.getColor().mediumVariant);
                builder.setEmissiveMaterial(false);
            }
            float offset = offsetConstant;
            offsetConstant += 0.001f;
            float buffer = 0.1f;
            float pos_x = s.x();
            float pos_y = s.y();
            pos_x = Math.max(0.1f, Math.min(0.9f, pos_x));
            pos_y = Math.max(0.1f, Math.min(0.9f, pos_y));
            TextureAtlasSprite ico = this.textures[s.getSeed() % this.textures.length];
            builder.setTexture(ico);
            builder.setCustomUv(s.getSide().m_122424_(), 0.0f, 0.0f, 16.0f, 16.0f);
            switch (s.getSide()) {
                case UP: {
                    offset = 1.0f - offset;
                    builder.addQuad(Direction.DOWN, pos_x - 0.1f, offset, pos_y - 0.1f, pos_x + 0.1f, offset, pos_y + 0.1f);
                    break;
                }
                case DOWN: {
                    builder.addQuad(Direction.UP, pos_x - 0.1f, offset, pos_y - 0.1f, pos_x + 0.1f, offset, pos_y + 0.1f);
                    break;
                }
                case EAST: {
                    offset = 1.0f - offset;
                    builder.addQuad(Direction.WEST, offset, pos_x - 0.1f, pos_y - 0.1f, offset, pos_x + 0.1f, pos_y + 0.1f);
                    break;
                }
                case WEST: {
                    builder.addQuad(Direction.EAST, offset, pos_x - 0.1f, pos_y - 0.1f, offset, pos_x + 0.1f, pos_y + 0.1f);
                    break;
                }
                case SOUTH: {
                    offset = 1.0f - offset;
                    builder.addQuad(Direction.NORTH, pos_x - 0.1f, pos_y - 0.1f, offset, pos_x + 0.1f, pos_y + 0.1f, offset);
                    break;
                }
                case NORTH: {
                    builder.addQuad(Direction.SOUTH, pos_x - 0.1f, pos_y - 0.1f, offset, pos_x + 0.1f, pos_y + 0.1f, offset);
                    break;
                }
            }
        }
        return builder.getOutput();
    }

    public boolean m_7541_() {
        return false;
    }

    public boolean m_7539_() {
        return true;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.textures[0];
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    public boolean m_7547_() {
        return false;
    }

    static List<Material> getRequiredTextures() {
        return ImmutableList.of((Object)TEXTURE_PAINT1, (Object)TEXTURE_PAINT2, (Object)TEXTURE_PAINT3);
    }
}

