/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.document.block;

import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.document.LytSize;
import appeng.client.guidebook.document.block.LytBlock;
import appeng.client.guidebook.document.interaction.GuideTooltip;
import appeng.client.guidebook.document.interaction.InteractiveElement;
import appeng.client.guidebook.document.interaction.TextTooltip;
import appeng.client.guidebook.layout.LayoutContext;
import appeng.client.guidebook.render.GuidePageTexture;
import appeng.client.guidebook.render.RenderContext;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class LytImage
extends LytBlock
implements InteractiveElement {
    private ResourceLocation imageId;
    private GuidePageTexture texture = GuidePageTexture.missing();
    private String title;
    private String alt;

    public ResourceLocation getImageId() {
        return this.imageId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAlt() {
        return this.alt;
    }

    public void setAlt(String alt) {
        this.alt = alt;
    }

    public void setImage(ResourceLocation id, byte @Nullable [] imageData) {
        this.imageId = id;
        this.texture = imageData != null ? GuidePageTexture.load(id, imageData) : GuidePageTexture.missing();
    }

    @Override
    protected LytRect computeLayout(LayoutContext context, int x, int y, int availableWidth) {
        if (this.texture == null) {
            return new LytRect(x, y, 32, 32);
        }
        LytSize size = this.texture.getSize();
        int width = size.width();
        int height = size.height();
        height /= 4;
        if ((width /= 4) > availableWidth) {
            float f = (float)availableWidth / (float)width;
            width = (int)((float)width * f);
            height = (int)((float)height * f);
        }
        return new LytRect(x, y, width, height);
    }

    @Override
    protected void onLayoutMoved(int deltaX, int deltaY) {
    }

    @Override
    public void renderBatch(RenderContext context, MultiBufferSource buffers) {
    }

    @Override
    public void render(RenderContext context) {
        if (this.texture == null) {
            DynamicTexture texture = MissingTextureAtlasSprite.m_118080_();
            context.fillTexturedRect(this.getBounds(), (AbstractTexture)texture);
        } else {
            context.fillTexturedRect(this.getBounds(), this.texture);
        }
    }

    @Override
    public Optional<GuideTooltip> getTooltip(float x, float y) {
        if (this.title != null) {
            return Optional.of(new TextTooltip((Component)Component.m_237113_((String)this.title), new Component[0]));
        }
        return Optional.empty();
    }
}

