/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.document.block.table;

import appeng.client.guidebook.color.ColorValue;
import appeng.client.guidebook.color.SymbolicColor;
import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.document.block.LytBlock;
import appeng.client.guidebook.document.block.table.LytTableCell;
import appeng.client.guidebook.document.block.table.LytTableColumn;
import appeng.client.guidebook.document.block.table.LytTableRow;
import appeng.client.guidebook.layout.LayoutContext;
import appeng.client.guidebook.render.RenderContext;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;

public class LytTable
extends LytBlock {
    private static final int CELL_BORDER = 1;
    private final List<LytTableRow> rows = new ArrayList<LytTableRow>();
    private final List<LytTableColumn> columns = new ArrayList<LytTableColumn>();

    @Override
    protected LytRect computeLayout(LayoutContext context, int x, int y, int availableWidth) {
        if (this.columns.isEmpty()) {
            return LytRect.empty();
        }
        int cellWidth = (availableWidth - (this.columns.size() + 1) * 1) / this.columns.size();
        int colX = x + 1;
        for (LytTableColumn column : this.columns) {
            column.x = colX;
            column.width = cellWidth;
            colX += column.width + 1;
        }
        LytTableColumn lastCol = this.columns.get(this.columns.size() - 1);
        lastCol.width = x + availableWidth - lastCol.x - 1;
        int currentY = y + 1;
        for (LytTableRow row : this.rows) {
            int rowTop = currentY;
            int rowBottom = currentY;
            for (LytTableCell cell : row.getChildren()) {
                LytTableColumn column = cell.column;
                LytRect cellBounds = cell.layout(context, column.x, currentY, column.width);
                rowBottom = Math.max(rowBottom, cellBounds.bottom());
            }
            row.bounds = new LytRect(x, rowTop, availableWidth, rowBottom - rowTop);
            currentY = rowBottom + 1;
        }
        return new LytRect(x, y, availableWidth, currentY - y);
    }

    @Override
    protected void onLayoutMoved(int deltaX, int deltaY) {
        for (LytTableColumn col : this.columns) {
            col.x += deltaX;
        }
        for (LytTableRow row : this.rows) {
            row.bounds = row.bounds.move(deltaX, deltaY);
            for (LytTableCell cell : row.getChildren()) {
                cell.setLayoutPos(cell.getBounds().point().add(deltaX, deltaY));
            }
        }
    }

    @Override
    public void renderBatch(RenderContext context, MultiBufferSource buffers) {
        for (LytTableRow row : this.getChildren()) {
            for (LytTableCell cell : row.getChildren()) {
                cell.renderBatch(context, buffers);
            }
        }
    }

    @Override
    public void render(RenderContext context) {
        int i;
        LytRect bounds = this.getBounds();
        for (i = 0; i < this.columns.size() - 1; ++i) {
            LytTableColumn column = this.columns.get(i);
            if (i == 0) {
                // empty if block
            }
            int colRight = column.x + column.width;
            context.fillRect(colRight, bounds.y(), 1, bounds.height(), (ColorValue)SymbolicColor.TABLE_BORDER);
        }
        for (i = 0; i < this.rows.size() - 1; ++i) {
            LytTableRow row = this.rows.get(i);
            if (i == 0) {
                // empty if block
            }
            context.fillRect(bounds.x(), row.bounds.bottom(), bounds.width(), 1, (ColorValue)SymbolicColor.TABLE_BORDER);
        }
        for (LytTableRow row : this.rows) {
            for (LytTableCell cell : row.getChildren()) {
                cell.render(context);
            }
        }
    }

    public LytTableRow appendRow() {
        LytTableRow row = new LytTableRow(this);
        this.rows.add(row);
        return row;
    }

    public List<LytTableColumn> getColumns() {
        return this.columns;
    }

    public LytTableColumn getOrCreateColumn(int index) {
        while (index >= this.columns.size()) {
            this.columns.add(new LytTableColumn());
        }
        return this.columns.get(index);
    }

    public List<LytTableRow> getChildren() {
        return this.rows;
    }
}

