/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import appeng.api.config.Actionable;
import appeng.api.util.DimensionalBlockPos;
import appeng.block.misc.TinyTNTBlock;
import appeng.core.AEConfig;
import appeng.hooks.IBlockTool;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.recipes.entropy.EntropyMode;
import appeng.recipes.entropy.EntropyRecipe;
import appeng.util.InteractionUtil;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class EntropyManipulatorItem
extends AEBasePoweredItem
implements IBlockTool {
    public static final int ENERGY_PER_USE = 1600;

    public EntropyManipulatorItem(Item.Properties props) {
        super(AEConfig.instance().getEntropyManipulatorBattery(), props);
    }

    @Override
    public double getChargeRate(ItemStack stack) {
        return 800.0;
    }

    public boolean m_7579_(ItemStack item, LivingEntity target, LivingEntity hitter) {
        if (this.getAECurrentPower(item) > 1600.0) {
            this.extractAEPower(item, 1600.0, Actionable.MODULATE);
            target.m_20254_(8);
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player p, InteractionHand hand) {
        BlockHitResult target = EntropyManipulatorItem.m_41435_((Level)level, (Player)p, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (target.m_6662_() != HitResult.Type.BLOCK) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)p.m_21120_(hand));
        }
        BlockPos pos = target.m_82425_();
        BlockState state = level.m_8055_(pos);
        if (!state.m_60819_().m_76178_() && Platform.hasPermissions(new DimensionalBlockPos(level, pos), p)) {
            UseOnContext context = new UseOnContext(p, hand, target);
            this.m_6225_(context);
        }
        return new InteractionResultHolder(InteractionResult.m_19078_((boolean)level.m_5776_()), (Object)p.m_21120_(hand));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockHitResult target;
        Level level = context.m_43725_();
        ItemStack item = context.m_43722_();
        BlockPos pos = context.m_8083_();
        Direction side = context.m_43719_();
        Player p = context.m_43723_();
        boolean tryBoth = false;
        if (p == null) {
            if (level.f_46443_) {
                return InteractionResult.FAIL;
            }
            p = Platform.getFakePlayer((ServerLevel)level, null);
            tryBoth = true;
        }
        if ((target = EntropyManipulatorItem.m_41435_((Level)level, (Player)p, (ClipContext.Fluid)ClipContext.Fluid.ANY)).m_6662_() == HitResult.Type.BLOCK) {
            pos = target.m_82425_();
        }
        if (this.getAECurrentPower(item) > 1600.0) {
            if (!p.m_36204_(pos, side, item)) {
                return InteractionResult.FAIL;
            }
            if (!level.m_5776_() && !this.tryApplyEffect(level, item, pos, side, p, tryBoth)) {
                return InteractionResult.FAIL;
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return InteractionResult.PASS;
    }

    private boolean tryApplyEffect(Level level, ItemStack item, BlockPos pos, Direction side, Player p, boolean tryBoth) {
        EntropyRecipe coolRecipe;
        BlockState blockState = level.m_8055_(pos);
        Block block = blockState.m_60734_();
        FluidState fluidState = level.m_6425_(pos);
        if ((tryBoth || InteractionUtil.isInAlternateUseMode(p)) && (coolRecipe = EntropyManipulatorItem.findRecipe(level, EntropyMode.COOL, blockState, fluidState)) != null) {
            this.extractAEPower(item, 1600.0, Actionable.MODULATE);
            EntropyManipulatorItem.applyRecipe(coolRecipe, level, pos, blockState, fluidState);
            return true;
        }
        if (tryBoth || !InteractionUtil.isInAlternateUseMode(p)) {
            if (block instanceof TntBlock) {
                level.m_7471_(pos, false);
                block.onCaughtFire(level.m_8055_(pos), level, pos, side, (LivingEntity)p);
                return true;
            }
            if (block instanceof TinyTNTBlock) {
                level.m_7471_(pos, false);
                ((TinyTNTBlock)block).startFuse(level, pos, (LivingEntity)p);
                return true;
            }
            EntropyRecipe heatRecipe = EntropyManipulatorItem.findRecipe(level, EntropyMode.HEAT, blockState, fluidState);
            if (heatRecipe != null) {
                this.extractAEPower(item, 1600.0, Actionable.MODULATE);
                EntropyManipulatorItem.applyRecipe(heatRecipe, level, pos, blockState, fluidState);
                return true;
            }
            if (this.performInWorldSmelting(item, level, p, pos, block)) {
                return true;
            }
            if (this.applyFlintAndSteelEffect(level, item, pos, side, p)) {
                return true;
            }
        }
        return false;
    }

    private boolean applyFlintAndSteelEffect(Level level, ItemStack item, BlockPos pos, Direction side, Player p) {
        BlockPos offsetPos = pos.m_121945_(side);
        if (!p.m_36204_(offsetPos, side, item)) {
            return false;
        }
        if (level.m_46859_(offsetPos)) {
            this.extractAEPower(item, 1600.0, Actionable.MODULATE);
            level.m_6263_(p, (double)offsetPos.m_123341_() + 0.5, (double)offsetPos.m_123342_() + 0.5, (double)offsetPos.m_123343_() + 0.5, SoundEvents.f_11942_, SoundSource.PLAYERS, 1.0f, level.f_46441_.m_188501_() * 0.4f + 0.8f);
            level.m_46597_(offsetPos, Blocks.f_50083_.m_49966_());
        }
        return true;
    }

    private boolean performInWorldSmelting(ItemStack item, Level level, Player p, BlockPos pos, Block block) {
        BlockState state = level.m_8055_(pos);
        List drops = Collections.emptyList();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockEntity be = level.m_7702_(pos);
            drops = Block.m_49874_((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)be, (Entity)p, (ItemStack)item);
        }
        BlockState smeltedBlockState = null;
        ArrayList<ItemStack> smeltedDrops = new ArrayList<ItemStack>();
        SimpleContainer tempInv = new SimpleContainer(1);
        for (ItemStack i : drops) {
            tempInv.m_6836_(0, i);
            Optional recipe = level.m_7465_().m_44015_(RecipeType.f_44108_, (Container)tempInv, level);
            if (!recipe.isPresent()) {
                return false;
            }
            ItemStack result = ((SmeltingRecipe)recipe.get()).m_5874_((Container)tempInv, level.m_9598_());
            if (result.m_41720_() instanceof BlockItem) {
                Block smeltedBlock = Block.m_49814_((Item)result.m_41720_());
                if (smeltedBlock == block) {
                    return false;
                }
                if (smeltedBlockState == null && !smeltedBlock.m_49966_().m_60795_()) {
                    smeltedBlockState = smeltedBlock.m_49966_();
                    continue;
                }
            }
            smeltedDrops.add(result);
        }
        if (smeltedBlockState == null && smeltedDrops.isEmpty()) {
            return false;
        }
        this.extractAEPower(item, 1600.0, Actionable.MODULATE);
        level.m_6263_(p, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11942_, SoundSource.PLAYERS, 1.0f, level.f_46441_.m_188501_() * 0.4f + 0.8f);
        if (smeltedBlockState == null) {
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        } else {
            level.m_7731_(pos, smeltedBlockState, 3);
        }
        Platform.spawnDrops(level, pos, smeltedDrops);
        return true;
    }

    @Nullable
    private static EntropyRecipe findRecipe(Level level, EntropyMode mode, BlockState blockState, FluidState fluidState) {
        for (EntropyRecipe recipe : level.m_7465_().m_44054_(EntropyRecipe.TYPE).values()) {
            if (!recipe.matches(mode, blockState, fluidState)) continue;
            return recipe;
        }
        return null;
    }

    private static void applyRecipe(EntropyRecipe recipe, Level level, BlockPos pos, BlockState blockState, FluidState fluidState) {
        BlockState outputBlockState = recipe.getOutputBlockState(blockState);
        if (outputBlockState != null) {
            level.m_7731_(pos, outputBlockState, 3);
        } else {
            FluidState outputFluidState = recipe.getOutputFluidState(fluidState);
            if (outputFluidState != null) {
                level.m_7731_(pos, outputFluidState.m_76188_(), 3);
            } else {
                level.m_46597_(pos, Blocks.f_50016_.m_49966_());
            }
        }
        if (!level.f_46443_) {
            for (ItemStack drop : recipe.getDrops()) {
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)drop.m_41777_());
            }
        }
        if (recipe.getMode() == EntropyMode.HEAT && !level.m_5776_()) {
            level.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)pos.m_123341_() + Math.random(), (double)pos.m_123342_() + Math.random(), (double)pos.m_123343_() + Math.random(), 0.0, 0.0, 0.0);
            }
        }
    }
}

