/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.entropy;

import appeng.recipes.entropy.PropertyUtils;
import appeng.recipes.entropy.StateMatcher;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

class SingleValueMatcher<T extends Comparable<T>>
implements StateMatcher {
    private final Property<T> property;
    private final T value;

    private SingleValueMatcher(Property<T> property, String value) {
        this.property = Objects.requireNonNull(property, "property must not be null");
        this.value = PropertyUtils.getRequiredPropertyValue(property, value);
    }

    @Override
    public boolean matches(StateHolder<?, ?> state) {
        return this.value.equals(state.m_61143_(this.property));
    }

    @Override
    public void writeToPacket(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)StateMatcher.MatcherType.SINGLE);
        buffer.m_130070_(this.property.m_61708_());
        buffer.m_130070_(this.property.m_6940_(this.value));
    }

    public String getValueName() {
        return this.property.m_6940_(this.value);
    }

    public Property<T> getProperty() {
        return this.property;
    }

    public static SingleValueMatcher<?> create(StateDefinition<?, ?> stateDefinition, String propertyName, String value) {
        Property<?> property = PropertyUtils.getRequiredProperty(stateDefinition, propertyName);
        return new SingleValueMatcher(property, value);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static SingleValueMatcher<?> readFromPacket(StateDefinition<?, ?> stateDefinition, FriendlyByteBuf buffer) {
        String propertyName = buffer.m_130277_();
        String value = buffer.m_130277_();
        return SingleValueMatcher.create(stateDefinition, propertyName, value);
    }
}

