/*
 * Decompiled with CFR 0.152.
 */
package appeng.siteexport.mdastpostprocess;

import appeng.client.guidebook.compiler.IdUtils;
import appeng.libs.mdast.MdAstVisitor;
import appeng.libs.mdast.mdx.model.MdxJsxElementFields;
import appeng.libs.mdast.model.MdAstImage;
import appeng.libs.mdast.model.MdAstNode;
import appeng.siteexport.ResourceExporter;
import java.nio.file.Path;
import net.minecraft.resources.ResourceLocation;

public class ImageExportVisitor
implements MdAstVisitor {
    private final ResourceExporter exporter;

    public ImageExportVisitor(ResourceExporter exporter) {
        this.exporter = exporter;
    }

    @Override
    public MdAstVisitor.Result beforeNode(MdAstNode node) {
        String src;
        MdxJsxElementFields fields;
        if (node instanceof MdAstImage) {
            MdAstImage image = (MdAstImage)node;
            image.url = this.rewriteAsset(image.url);
        } else if (node instanceof MdxJsxElementFields && "FloatingImage".equals((fields = (MdxJsxElementFields)((Object)node)).name()) && (src = fields.getAttributeString("src", null)) != null) {
            String newSrc = this.rewriteAsset(src);
            fields.setAttribute("src", newSrc);
        }
        return MdAstVisitor.Result.CONTINUE;
    }

    private String rewriteAsset(String url) {
        ResourceLocation assetId = IdUtils.resolveLink(url, this.exporter.getCurrentPageId());
        Path assetPath = this.exporter.copyResource(assetId);
        return this.exporter.getPathRelativeFromOutputFolder(assetPath);
    }
}

