/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config.ui;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import dev.ftb.mods.ftblibrary.config.ui.SelectableResource;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.util.client.ClientUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.Fluid;

public interface ResourceSearchMode<T> {
    public static final ResourceSearchMode<ItemStack> ALL_ITEMS = new ResourceSearchMode<ItemStack>(){
        private List<SelectableResource<ItemStack>> allItemsCache = null;

        @Override
        public Icon getIcon() {
            return Icons.COMPASS;
        }

        @Override
        public MutableComponent getDisplayName() {
            return Component.m_237115_((String)"ftblibrary.select_item.list_mode.all");
        }

        @Override
        public Collection<? extends SelectableResource<ItemStack>> getAllResources() {
            if (this.allItemsCache == null) {
                CreativeModeTabs.m_269226_((FeatureFlagSet)FeatureFlags.f_244332_, (boolean)false, (HolderLookup.Provider)ClientUtils.registryAccess());
                this.allItemsCache = CreativeModeTabs.m_258007_().m_260957_().stream().map(SelectableResource::item).toList();
            }
            return this.allItemsCache;
        }
    };
    public static final ResourceSearchMode<ItemStack> INVENTORY = new ResourceSearchMode<ItemStack>(){

        @Override
        public Icon getIcon() {
            return ItemIcon.getItemIcon(Items.f_42009_);
        }

        @Override
        public MutableComponent getDisplayName() {
            return Component.m_237115_((String)"ftblibrary.select_item.list_mode.inv");
        }

        @Override
        public Collection<? extends SelectableResource<ItemStack>> getAllResources() {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return Collections.emptySet();
            }
            int invSize = player.m_150109_().m_6643_();
            ArrayList<SelectableResource<ItemStack>> items = new ArrayList<SelectableResource<ItemStack>>(invSize);
            for (int i = 0; i < invSize; ++i) {
                ItemStack stack = player.m_150109_().m_8020_(i);
                if (stack.m_41619_()) continue;
                items.add(SelectableResource.item(stack));
            }
            return items;
        }
    };
    public static final ResourceSearchMode<FluidStack> ALL_FLUIDS = new ResourceSearchMode<FluidStack>(){
        private List<SelectableResource<FluidStack>> allFluidsCache = null;

        @Override
        public Icon getIcon() {
            return ItemIcon.getItemIcon(Items.f_42522_);
        }

        @Override
        public MutableComponent getDisplayName() {
            return Component.m_237115_((String)"ftblibrary.select_fluid.list_mode.all");
        }

        @Override
        public Collection<? extends SelectableResource<FluidStack>> getAllResources() {
            if (this.allFluidsCache == null) {
                ArrayList fluidstacks = new ArrayList();
                BuiltInRegistries.f_257020_.forEach(f -> {
                    if (f.m_7444_(f.m_76145_())) {
                        fluidstacks.add(SelectableResource.fluid(FluidStack.create((Fluid)f, (long)FluidStackHooks.bucketAmount())));
                    }
                });
                this.allFluidsCache = List.copyOf(fluidstacks);
            }
            return this.allFluidsCache;
        }
    };

    public Icon getIcon();

    public MutableComponent getDisplayName();

    public Collection<? extends SelectableResource<T>> getAllResources();
}

