/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;
import net.minecraftforge.network.NetworkHooks;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlockClientExtensions;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelMaterial;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.client.particle.CustomTintTerrainParticleData;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.StorageContainerMenu;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.BarrelBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;
import org.jetbrains.annotations.Nullable;

public class BarrelBlock
extends WoodStorageBlockBase {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final BooleanProperty FLAT_TOP = BooleanProperty.m_61465_((String)"flat_top");
    private static final VoxelShape ITEM_ENTITY_COLLISION_SHAPE = BarrelBlock.m_49796_((double)0.05, (double)0.05, (double)0.05, (double)15.95, (double)15.95, (double)15.95);

    public BarrelBlock(Supplier<Integer> numberOfInventorySlotsSupplier, Supplier<Integer> numberOfUpgradeSlotsSupplier, BlockBehaviour.Properties properties) {
        this(numberOfInventorySlotsSupplier, numberOfUpgradeSlotsSupplier, properties, stateDef -> (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)stateDef.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TICKING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FLAT_TOP, (Comparable)Boolean.valueOf(false)));
    }

    public BarrelBlock(Supplier<Integer> numberOfInventorySlotsSupplier, Supplier<Integer> numberOfUpgradeSlotsSupplier, BlockBehaviour.Properties properties, Function<StateDefinition<Block, BlockState>, BlockState> getDefaultState) {
        super(properties, numberOfInventorySlotsSupplier, numberOfUpgradeSlotsSupplier);
        this.m_49959_(getDefaultState.apply((StateDefinition<Block, BlockState>)this.f_49792_));
    }

    @Override
    public void addCreativeTabItems(Consumer<ItemStack> itemConsumer) {
        super.addCreativeTabItems(itemConsumer);
        if (this != ModBlocks.BARREL.get()) {
            return;
        }
        ItemStack flatBarrel = WoodStorageBlockItem.setWoodType(new ItemStack((ItemLike)this), WoodType.f_61833_);
        BarrelBlockItem.toggleFlatTop(flatBarrel);
        itemConsumer.accept(flatBarrel);
    }

    public boolean m_180643_(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel level, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        level.m_8767_((ParticleOptions)new CustomTintTerrainParticleData(state1, pos), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), numberOfParticles, 0.0, 0.0, 0.0, 0.15);
        return true;
    }

    public boolean addRunningEffects(BlockState state, Level level, BlockPos pos, Entity entity) {
        Vec3 vec3 = entity.m_20184_();
        level.m_7106_((ParticleOptions)new CustomTintTerrainParticleData(state, pos), entity.m_20185_() + (level.f_46441_.m_188500_() - 0.5) * (double)entity.m_20205_(), entity.m_20186_() + 0.1, entity.m_20189_() + (level.f_46441_.m_188500_() - 0.5) * (double)entity.m_20205_(), vec3.f_82479_ * -4.0, 1.5, vec3.f_82481_ * -4.0);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(new BarrelBlockClientExtensions(this));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, WoodStorageBlockEntity.class).map(b -> {
            ItemStack stackInHand = player.m_21120_(hand);
            if (b.isPacked()) {
                return InteractionResult.PASS;
            }
            if (level.f_46443_ || hand == InteractionHand.OFF_HAND) {
                return InteractionResult.SUCCESS;
            }
            if (this.tryItemInteraction(player, hand, (WoodStorageBlockEntity)b, stackInHand, this.getFacing(state), hitResult)) {
                return InteractionResult.SUCCESS;
            }
            player.m_36220_(Stats.f_12971_);
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((w, p, pl) -> this.instantiateContainerMenu(w, pl, pos), WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, StorageBlockEntity.class).map(StorageBlockEntity::m_5446_).orElse((Component)Component.m_237119_())), (BlockPos)pos);
            PiglinAi.m_34873_((Player)player, (boolean)true);
            return InteractionResult.CONSUME;
        }).orElse(InteractionResult.PASS);
    }

    @Override
    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, BarrelBlockEntity.class).ifPresent(barrel -> {
            Map<BarrelMaterial, ResourceLocation> materials = BarrelBlockItem.getMaterials(stack);
            if (!materials.isEmpty()) {
                barrel.setMaterials(materials);
            }
        });
    }

    protected StorageContainerMenu instantiateContainerMenu(int w, Player pl, BlockPos pos) {
        return new StorageContainerMenu(w, pl, pos);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, StorageBlockEntity.class).ifPresent(StorageBlockEntity::recheckOpen);
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation direction) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)direction.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, OPEN, TICKING, FLAT_TOP});
    }

    @Override
    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemStack cloneItemStack = super.getCloneItemStack(state, target, world, pos, player);
        BarrelBlockItem.setFlatTop(cloneItemStack, (Boolean)state.m_61143_((Property)FLAT_TOP));
        WorldHelper.getBlockEntity((BlockGetter)world, (BlockPos)pos, BarrelBlockEntity.class).ifPresent(barrelBlockEntity -> {
            Map<BarrelMaterial, ResourceLocation> materials = barrelBlockEntity.getMaterials();
            if (!materials.isEmpty()) {
                BarrelBlockItem.setMaterials(cloneItemStack, materials);
            }
        });
        return cloneItemStack;
    }

    @Override
    public void addDropData(ItemStack stack, StorageBlockEntity be) {
        BarrelBlockEntity barrelBlockEntity;
        Map<BarrelMaterial, ResourceLocation> materials;
        super.addDropData(stack, be);
        BlockState state = be.m_58900_();
        BarrelBlockItem.setFlatTop(stack, (Boolean)state.m_61143_((Property)FLAT_TOP));
        if (be instanceof BarrelBlockEntity && !(materials = (barrelBlockEntity = (BarrelBlockEntity)be).getMaterials()).isEmpty()) {
            BarrelBlockItem.setMaterials(stack, materials);
        }
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)blockPlaceContext.m_7820_().m_122424_())).m_61124_((Property)FLAT_TOP, (Comparable)Boolean.valueOf(BarrelBlockItem.isFlatTop(blockPlaceContext.m_43722_())));
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        EntityCollisionContext entityCollisionContext;
        return context instanceof EntityCollisionContext && (entityCollisionContext = (EntityCollisionContext)context).m_193113_() instanceof ItemEntity || this.isCalledByCollisionCacheLogic(level, pos) ? ITEM_ENTITY_COLLISION_SHAPE : super.m_5939_(state, level, pos, context);
    }

    public VoxelShape m_7947_(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return Shapes.m_83144_();
    }

    private boolean isCalledByCollisionCacheLogic(BlockGetter level, BlockPos pos) {
        return level instanceof EmptyBlockGetter && pos == BlockPos.f_121853_;
    }

    @Override
    @javax.annotation.Nullable
    public StorageBlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BarrelBlockEntity(pos, state);
    }

    @Override
    protected BlockEntityType<? extends StorageBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModBlocks.BARREL_BLOCK_ENTITY_TYPE.get();
    }

    @Override
    public Direction getFacing(BlockState state) {
        return (Direction)state.m_61143_((Property)FACING);
    }

    public VoxelShape m_7952_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return Shapes.m_83144_();
    }

    public boolean m_7923_(BlockState pState) {
        return true;
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }
}

