/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.item;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedcore.util.BlockItemBase;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.IStorageBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ItemContentsStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;

abstract class StackStorageWrapper
extends StorageWrapper {
    private static final String CONTENTS_TAG = "contents";
    private final ItemStack storageStack;

    public StackStorageWrapper(ItemStack storageStack) {
        super(() -> () -> {}, () -> {}, () -> {});
        this.storageStack = storageStack;
    }

    private UUID getNewUuid() {
        UUID newUuid = UUID.randomUUID();
        this.setContentsUuid(newUuid);
        return newUuid;
    }

    public Optional<UUID> getContentsUuid() {
        return Optional.ofNullable(this.contentsUuid);
    }

    @Override
    public void setContentsUuid(@Nullable UUID contentsUuid) {
        super.setContentsUuid(contentsUuid);
        if (contentsUuid != null) {
            NBTHelper.setUniqueId((ItemStack)this.storageStack, (String)"uuid", (UUID)contentsUuid);
            ItemContentsStorage itemContentsStorage = ItemContentsStorage.get();
            CompoundTag storageContents = itemContentsStorage.getOrCreateStorageContents(contentsUuid);
            if (!storageContents.m_128441_("storageWrapper")) {
                CompoundTag storageWrapperTag = new CompoundTag();
                storageWrapperTag.m_128365_(CONTENTS_TAG, (Tag)new CompoundTag());
                storageContents.m_128365_("storageWrapper", (Tag)storageWrapperTag);
            }
            this.onContentsNbtUpdated();
        }
    }

    @Override
    protected CompoundTag getContentsNbt() {
        if (this.contentsUuid == null) {
            this.contentsUuid = this.getNewUuid();
        }
        return ItemContentsStorage.get().getOrCreateStorageContents(this.contentsUuid).m_128469_("storageWrapper").m_128469_(CONTENTS_TAG);
    }

    @Override
    protected void onUpgradeRefresh() {
    }

    @Override
    public int getDefaultNumberOfInventorySlots() {
        int n;
        BlockItemBase blockItem;
        Item item = this.storageStack.m_41720_();
        if (item instanceof BlockItemBase && (item = (blockItem = (BlockItemBase)item).m_40614_()) instanceof IStorageBlock) {
            IStorageBlock storageBlock = (IStorageBlock)item;
            n = storageBlock.getNumberOfInventorySlots();
        } else {
            n = 0;
        }
        return n;
    }

    @Override
    protected void loadSlotNumbers(CompoundTag tag) {
        this.numberOfInventorySlots = NBTHelper.getInt((ItemStack)this.storageStack, (String)"numberOfInventorySlots").orElse(0);
        this.numberOfUpgradeSlots = NBTHelper.getInt((ItemStack)this.storageStack, (String)"numberOfUpgradeSlots").orElse(0);
    }

    @Override
    public int getDefaultNumberOfUpgradeSlots() {
        int n;
        BlockItemBase blockItem;
        Item item = this.storageStack.m_41720_();
        if (item instanceof BlockItemBase && (item = (blockItem = (BlockItemBase)item).m_40614_()) instanceof IStorageBlock) {
            IStorageBlock storageBlock = (IStorageBlock)item;
            n = storageBlock.getNumberOfUpgradeSlots();
        } else {
            n = 0;
        }
        return n;
    }
}

