/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.upgrades.hopper;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ContentsFilterLogic;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;

public class TargetContentsFilterLogic
extends ContentsFilterLogic {
    private Set<ItemStackKey> inventoryFilterStacks = new HashSet<ItemStackKey>();
    private final LoadingCache<IItemHandler, Set<ItemStackKey>> inventoryCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<IItemHandler, Set<ItemStackKey>>(){

        public Set<ItemStackKey> load(IItemHandler inventory) {
            return InventoryHelper.getUniqueStacks((IItemHandler)inventory);
        }
    });

    public TargetContentsFilterLogic(ItemStack upgrade, Consumer<ItemStack> saveHandler, int filterSlotCount, Supplier<InventoryHandler> getInventoryHandler, MemorySettingsCategory memorySettings, String parentTagKey) {
        super(upgrade, saveHandler, filterSlotCount, getInventoryHandler, memorySettings, parentTagKey);
    }

    public void setInventory(IItemHandler inventory) {
        this.inventoryFilterStacks = (Set)this.inventoryCache.getUnchecked((Object)inventory);
    }

    public boolean matchesFilter(ItemStack stack) {
        if (!this.shouldFilterByStorage()) {
            return super.matchesFilter(stack);
        }
        for (ItemStackKey filterStack : this.inventoryFilterStacks) {
            if (!this.stackMatchesFilter(stack, filterStack.getStack())) continue;
            return true;
        }
        return false;
    }
}

