/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced.world.structure.prefabs;

import com.barion.dungeons_enhanced.world.structure.prefabs.utils.DEPieceAssembler;
import com.barion.dungeons_enhanced.world.structure.prefabs.utils.DEStructureTemplates;
import com.legacy.structure_gel.api.registry.registrar.Registrar;
import com.legacy.structure_gel.api.structure.GelTemplateStructurePiece;
import com.legacy.structure_gel.api.structure.processor.RemoveGelStructureProcessor;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.jetbrains.annotations.NotNull;

public abstract class DEBaseStructure
extends Structure {
    protected final DEStructureTemplates Templates;
    protected final Supplier<StructureType<?>> TypeSupplier;

    public DEBaseStructure(Structure.StructureSettings settings, DEStructureTemplates templates, Supplier<StructureType<?>> type) {
        super(settings);
        this.Templates = templates;
        this.TypeSupplier = type;
    }

    protected static Optional<Structure.GenerationStub> at(BlockPos pos, Consumer<StructurePiecesBuilder> piecesBuilder) {
        return Optional.of(new Structure.GenerationStub(pos, piecesBuilder));
    }

    @NotNull
    protected Optional<Structure.GenerationStub> m_214086_(@NotNull Structure.GenerationContext generationContext) {
        return Optional.empty();
    }

    @Nonnull
    public StructureType<?> m_213658_() {
        return this.TypeSupplier.get();
    }

    protected static void generatePieces(StructurePiecesBuilder piecesBuilder, BlockPos pos, DEStructureTemplates.Template template, Rotation rotation, Structure.GenerationContext context, DEPieceAssembler assembler) {
        assembler.assemble(new DEPieceAssembler.Context(context.f_226625_(), template.Resource, pos, rotation, piecesBuilder));
    }

    public static class Piece
    extends GelTemplateStructurePiece {
        private Rotation rotation;

        public Piece(Registrar.Static<StructurePieceType> pieceType, StructureTemplateManager structureManager, ResourceLocation templateName, BlockPos pos, Rotation rotation) {
            super((StructurePieceType)pieceType.get(), 0, structureManager, templateName, pos);
            this.rotation = rotation;
            this.setupPlaceSettings(structureManager);
        }

        public Piece(Registrar.Static<StructurePieceType> pieceType, StructurePieceSerializationContext context, CompoundTag nbt) {
            super((StructurePieceType)pieceType.get(), nbt, context.f_226956_());
            this.setupPlaceSettings(context.f_226956_());
        }

        protected StructurePlaceSettings getPlaceSettings(StructureTemplateManager structureManager) {
            Vec3i size = ((StructureTemplate)structureManager.m_230407_(this.m_142415_()).get()).m_163801_();
            BlockPos pivot = new BlockPos(size.m_123341_() / 2, 0, size.m_123343_() / 2);
            StructurePlaceSettings settings = new StructurePlaceSettings().m_163782_(false).m_74385_(pivot).m_74379_(this.rotation);
            settings.m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74048_).m_74383_((StructureProcessor)RemoveGelStructureProcessor.INSTANCE);
            this.addProcessors(settings);
            return settings;
        }

        protected void addProcessors(StructurePlaceSettings settings) {
        }

        @ParametersAreNonnullByDefault
        protected void m_213704_(String key, BlockPos pos, ServerLevelAccessor level, RandomSource random, BoundingBox box) {
        }
    }
}

