/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced.world.structure.prefabs;

import com.barion.dungeons_enhanced.DEStructures;
import com.barion.dungeons_enhanced.DEUtil;
import com.barion.dungeons_enhanced.world.structure.prefabs.DEBaseStructure;
import com.barion.dungeons_enhanced.world.structure.prefabs.utils.DEPieceAssembler;
import com.barion.dungeons_enhanced.world.structure.prefabs.utils.DEStructureTemplates;
import com.legacy.structure_gel.api.registry.registrar.Registrar;
import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class DEFlyingStructure
extends DEBaseStructure {
    public static final String ID_FLYING_DUTCHMAN = "flying_dutchman";
    public static final Codec<DEFlyingStructure> CODEC_FLYING_DUTCHMAN = DEFlyingStructure.m_226607_(DEFlyingStructure::FlyingDutchman);

    public static DEFlyingStructure FlyingDutchman(Structure.StructureSettings settings) {
        return new DEFlyingStructure(settings, DEUtil.pieceBuilder().add(ID_FLYING_DUTCHMAN).build(), () -> DEStructures.FLYING_DUTCHMAN.getType());
    }

    protected DEFlyingStructure(Structure.StructureSettings settings, DEStructureTemplates variants, Supplier<StructureType<?>> type) {
        super(settings, variants, type);
    }

    public static void assemble(DEPieceAssembler.Context context) {
        context.piecesBuilder().m_142679_((StructurePiece)new Piece(context.structureManager(), context.piece(), context.pos(), context.rotation()));
    }

    @Override
    @Nonnull
    public Optional<Structure.GenerationStub> m_214086_(@Nonnull Structure.GenerationContext context) {
        int maxY;
        BlockPos rawPos = DEUtil.ChunkPosToBlockPosFromHeightMap(context.f_226628_(), context.f_226622_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_());
        if (rawPos.m_123342_() > 224) {
            return Optional.empty();
        }
        int minY = rawPos.m_123342_() + 48;
        int y = maxY = 288;
        if (maxY > minY) {
            y = minY + context.f_226626_().m_188503_(maxY - minY);
        }
        BlockPos pos = rawPos.m_175288_(y);
        return DEFlyingStructure.at(pos, builder -> DEFlyingStructure.generatePieces(builder, pos, this.Templates.getRandom((RandomSource)context.f_226626_()), Rotation.m_221990_((RandomSource)context.f_226626_()), context, DEFlyingStructure::assemble));
    }

    public static class Piece
    extends DEBaseStructure.Piece {
        public Piece(StructureTemplateManager structureManager, ResourceLocation templateName, BlockPos pos, Rotation rotation) {
            super((Registrar.Static<StructurePieceType>)DEStructures.FLYING_DUTCHMAN.getPieceType(), structureManager, templateName, pos, rotation);
        }

        public Piece(StructurePieceSerializationContext serializationContext, CompoundTag nbt) {
            super((Registrar.Static<StructurePieceType>)DEStructures.FLYING_DUTCHMAN.getPieceType(), serializationContext, nbt);
        }
    }
}

