/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.network;

import net.blay09.mods.craftingtweaks.CraftingTweaksProviderManager;
import net.blay09.mods.craftingtweaks.api.CraftingGrid;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class RotateMessage {
    private final ResourceLocation id;
    private final boolean reverse;

    public RotateMessage(ResourceLocation id, boolean reverse) {
        this.id = id;
        this.reverse = reverse;
    }

    public static RotateMessage decode(FriendlyByteBuf buf) {
        ResourceLocation id = buf.m_130281_();
        boolean counterClockwise = buf.readBoolean();
        return new RotateMessage(id, counterClockwise);
    }

    public static void encode(RotateMessage message, FriendlyByteBuf buf) {
        buf.m_130085_(message.id);
        buf.writeBoolean(message.reverse);
    }

    public static void handle(ServerPlayer player, RotateMessage message) {
        if (player == null) {
            return;
        }
        AbstractContainerMenu menu = player.f_36096_;
        if (menu != null) {
            CraftingTweaksProviderManager.getCraftingGrid(menu, message.id).ifPresent(grid -> grid.rotateHandler().rotateGrid((CraftingGrid)grid, (Player)player, menu, message.reverse));
        }
    }
}

