/*
 * Decompiled with CFR 0.152.
 */
package systems.alexander.bellsandwhistles.block.custom;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.decoration.copycat.CopycatSpecialCases;
import com.simibubi.create.foundation.placement.IPlacementHelper;
import com.simibubi.create.foundation.placement.PlacementHelpers;
import com.simibubi.create.foundation.placement.PlacementOffset;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PanelBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    protected static final int AABB_THICKNESS = 3;
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());

    public PanelBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.UP));
    }

    public static BlockState getMaterial(BlockGetter reader, BlockPos targetPos) {
        return Blocks.f_50079_.m_49966_();
    }

    public boolean canFaceBeOccluded(BlockState state, Direction face) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122424_() == face;
    }

    public boolean shouldFaceAlwaysRender(BlockState state, Direction face) {
        return this.canFaceBeOccluded(state, face.m_122424_());
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState stateForPlacement = super.m_5573_(pContext);
        return (BlockState)stateForPlacement.m_61124_((Property)FACING, (Comparable)pContext.m_7820_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder.m_61104_(new Property[]{FACING}));
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        return true;
    }

    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        if (state.m_60713_((Block)this) == neighborState.m_60713_((Block)this)) {
            if (CopycatSpecialCases.isBarsMaterial((BlockState)PanelBlock.getMaterial(level, pos)) && CopycatSpecialCases.isBarsMaterial((BlockState)PanelBlock.getMaterial(level, pos.m_121945_(dir)))) {
                return state.m_61143_((Property)FACING) == neighborState.m_61143_((Property)FACING);
            }
            if (PanelBlock.getMaterial(level, pos).m_60719_(PanelBlock.getMaterial(level, pos.m_121945_(dir)), dir.m_122424_())) {
                return PanelBlock.isOccluded(state, neighborState, dir.m_122424_());
            }
        }
        return state.m_61143_((Property)FACING) == dir.m_122424_() && PanelBlock.getMaterial(level, pos).m_60719_(neighborState, dir.m_122424_());
    }

    public static boolean isOccluded(BlockState state, BlockState other, Direction pDirection) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        if (facing.m_122424_() == other.m_61143_((Property)FACING) && pDirection == facing) {
            return true;
        }
        if (other.m_61143_((Property)FACING) != facing) {
            return false;
        }
        return pDirection.m_122434_() != facing.m_122434_();
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AllShapes.CASING_3PX.get((Direction)pState.m_61143_((Property)FACING));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    implements IPlacementHelper {
        private PlacementHelper() {
        }

        public Predicate<ItemStack> getItemPredicate() {
            return arg_0 -> ((BlockEntry)AllBlocks.COPYCAT_PANEL).isIn(arg_0);
        }

        public Predicate<BlockState> getStatePredicate() {
            return arg_0 -> ((BlockEntry)AllBlocks.COPYCAT_PANEL).has(arg_0);
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            List directions = IPlacementHelper.orderedByDistanceExceptAxis((BlockPos)pos, (Vec3)ray.m_82450_(), (Direction.Axis)((Direction)state.m_61143_((Property)FACING)).m_122434_(), dir -> world.m_8055_(pos.m_121945_(dir)).m_247087_());
            if (directions.isEmpty()) {
                return PlacementOffset.fail();
            }
            return PlacementOffset.success((Vec3i)pos.m_121945_((Direction)directions.get(0)), s -> (BlockState)s.m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING))));
        }
    }
}

