/*
 * Decompiled with CFR 0.152.
 */
package io.ejekta.bountiful.forge;

import com.mojang.brigadier.CommandDispatcher;
import io.ejekta.bountiful.Bountiful;
import io.ejekta.bountiful.bridge.Bountybridge;
import io.ejekta.bountiful.config.BountifulIO;
import io.ejekta.bountiful.content.BountifulCommands;
import io.ejekta.bountiful.content.BountifulContent;
import io.ejekta.bountiful.forge.BountifulForgeClient;
import io.ejekta.kambrik.Kambrik;
import io.ejekta.kambrik.internal.registration.KambrikRegistrar;
import io.ejekta.kambrik.registration.KambrikAutoRegistrar;
import io.ejekta.kambrik.structure.KambrikStructureApi;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.RegisterEvent;
import org.jetbrains.annotations.NotNull;
import thedarkcolour.kotlinforforge.KotlinModLoadingContext;

@Mod(value="bountiful")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lio/ejekta/bountiful/forge/BountifulModForge;", "", "Lnet/minecraftforge/event/entity/living/LivingDeathEvent;", "evt", "", "onEntityKilled", "(Lnet/minecraftforge/event/entity/living/LivingDeathEvent;)V", "Lnet/minecraftforge/event/AddReloadListenerEvent;", "onGameReload", "(Lnet/minecraftforge/event/AddReloadListenerEvent;)V", "Lnet/minecraftforge/event/server/ServerStartingEvent;", "onServerStarting", "(Lnet/minecraftforge/event/server/ServerStartingEvent;)V", "Lnet/minecraftforge/event/RegisterCommandsEvent;", "registerCommands", "(Lnet/minecraftforge/event/RegisterCommandsEvent;)V", "Lnet/minecraftforge/registries/RegisterEvent;", "registerRegistryContent", "(Lnet/minecraftforge/registries/RegisterEvent;)V", "<init>", "()V", "Bountiful"})
@SourceDebugExtension(value={"SMAP\nBountifulModForge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BountifulModForge.kt\nio/ejekta/bountiful/forge/BountifulModForge\n+ 2 Forge.kt\nthedarkcolour/kotlinforforge/forge/ForgeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n27#2:97\n27#2:98\n27#2:99\n27#2:100\n45#2:101\n80#2:102\n52#2:103\n81#2:104\n45#2:105\n83#2:106\n1855#3,2:107\n1855#3,2:109\n*S KotlinDebug\n*F\n+ 1 BountifulModForge.kt\nio/ejekta/bountiful/forge/BountifulModForge\n*L\n39#1:97\n40#1:98\n41#1:99\n42#1:100\n44#1:101\n46#1:102\n46#1:103\n46#1:104\n48#1:105\n46#1:106\n66#1:107,2\n90#1:109,2\n*E\n"})
public final class BountifulModForge {
    public BountifulModForge() {
        Bountybridge.Companion.registerServerMessages();
        Bountybridge.Companion.registerClientMessages();
        boolean $i$f$getFORGE_BUS = false;
        IEventBus iEventBus = MinecraftForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus, (String)"EVENT_BUS");
        iEventBus.addListener(this::registerCommands);
        $i$f$getFORGE_BUS = false;
        IEventBus iEventBus2 = MinecraftForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus2, (String)"EVENT_BUS");
        iEventBus2.addListener(this::onGameReload);
        $i$f$getFORGE_BUS = false;
        IEventBus iEventBus3 = MinecraftForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus3, (String)"EVENT_BUS");
        iEventBus3.addListener(this::onEntityKilled);
        $i$f$getFORGE_BUS = false;
        IEventBus iEventBus4 = MinecraftForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus4, (String)"EVENT_BUS");
        iEventBus4.addListener(this::onServerStarting);
        boolean $i$f$getMOD_CONTEXT = false;
        KotlinModLoadingContext.Companion.get().getKEventBus().register((Object)this);
        boolean $i$f$runForDist = false;
        boolean $i$f$getDIST = false;
        Dist dist = FMLEnvironment.dist;
        Intrinsics.checkNotNullExpressionValue((Object)dist, (String)"dist");
        if (dist == Dist.CLIENT) {
            boolean bl = false;
            boolean $i$f$getMOD_CONTEXT2 = false;
            KotlinModLoadingContext.Companion.get().getKEventBus().register(BountifulForgeClient.class);
        } else {
            boolean bl = false;
        }
        Bountybridge.Companion.registerCriterionStuff();
    }

    private final void onEntityKilled(LivingDeathEvent evt) {
        block1: {
            Entity entity = evt.getSource().m_7639_();
            if (entity == null) break block1;
            Entity attacker = entity;
            boolean bl = false;
            Level level = evt.getEntity().m_9236_();
            ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
            if (serverLevel != null) {
                ServerLevel serverWorld = serverLevel;
                boolean bl2 = false;
                LivingEntity livingEntity = evt.getEntity();
                Intrinsics.checkNotNullExpressionValue((Object)livingEntity, (String)"evt.entity");
                Bountybridge.Companion.handleEntityKills(serverWorld, attacker, livingEntity);
            }
        }
    }

    private final void onServerStarting(ServerStartingEvent evt) {
        Object[] objectArray = new String[]{"plains", "savanna", "snowy", "taiga", "desert"};
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String villageType = (String)element$iv;
            boolean bl = false;
            Bountiful.Companion.getLOGGER().info("Registering Bounty Board Jigsaw Piece for Village Type: " + villageType);
            KambrikStructureApi kambrikStructureApi = Kambrik.INSTANCE.getStructure();
            MinecraftServer minecraftServer = evt.getServer();
            Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"evt.server");
            kambrikStructureApi.addToStructurePool(minecraftServer, new ResourceLocation("bountiful:village/common/bounty_gazebo"), new ResourceLocation("minecraft:village/" + villageType + "/houses"), new ResourceLocation("bountiful:" + villageType), BountifulIO.INSTANCE.getConfigData().getBoardGenFrequency());
        }
    }

    private final void onGameReload(AddReloadListenerEvent evt) {
        evt.addListener((PreparableReloadListener)((ResourceManagerReloadListener)BountifulModForge::onGameReload$lambda$5));
    }

    private final void registerCommands(RegisterCommandsEvent evt) {
        CommandDispatcher commandDispatcher = evt.getDispatcher();
        Intrinsics.checkNotNullExpressionValue((Object)commandDispatcher, (String)"evt.dispatcher");
        CommandBuildContext commandBuildContext = evt.getBuildContext();
        Intrinsics.checkNotNullExpressionValue((Object)commandBuildContext, (String)"evt.buildContext");
        BountifulCommands.INSTANCE.register((CommandDispatcher<CommandSourceStack>)commandDispatcher, commandBuildContext, evt.getCommandSelection());
    }

    @SubscribeEvent
    public final void registerRegistryContent(@NotNull RegisterEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        Iterable $this$forEach$iv = KambrikRegistrar.INSTANCE.get((KambrikAutoRegistrar)BountifulContent.INSTANCE).getContent();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KambrikRegistrar.RegistrationEntry entry = (KambrikRegistrar.RegistrationEntry)element$iv;
            boolean bl = false;
            ResourceKey resourceKey = entry.getRegistry().m_123023_();
            Intrinsics.checkNotNull((Object)resourceKey, (String)"null cannot be cast to non-null type net.minecraft.registry.RegistryKey<out net.minecraft.registry.Registry<kotlin.Any>>");
            evt.register(resourceKey, new ResourceLocation(BountifulContent.INSTANCE.getId(), entry.getItemId()), () -> BountifulModForge.registerRegistryContent$lambda$7$lambda$6(entry));
        }
    }

    private static final void onGameReload$lambda$5(ResourceManager manager) {
        Intrinsics.checkNotNullExpressionValue((Object)manager, (String)"manager");
        BountifulIO.INSTANCE.doContentReload(manager);
    }

    private static final Object registerRegistryContent$lambda$7$lambda$6(KambrikRegistrar.RegistrationEntry $entry) {
        Intrinsics.checkNotNullParameter((Object)$entry, (String)"$entry");
        return $entry.getItem();
    }
}

