/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blockentities;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.abraxator.moresnifferflowers.blocks.rebrewingstand.RebrewingStandBlockBase;
import net.abraxator.moresnifferflowers.client.gui.menu.RebrewingStandMenu;
import net.abraxator.moresnifferflowers.init.ModBlockEntities;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.abraxator.moresnifferflowers.init.ModMobEffects;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;

public class RebrewingStandBlockEntity
extends BaseContainerBlockEntity {
    public static final double MAX_FUEL = 16.0;
    public static final int DATA_PROGRESS = 0;
    public static final int DATA_FUEL = 1;
    public static final int MAX_PROGRESS = 100;
    private NonNullList<ItemStack> inv = NonNullList.m_122780_((int)6, (Object)ItemStack.f_41583_);
    int brewProgress;
    int fuel;
    int cost;
    private boolean[] lastPotionCount;
    public final ContainerData containerData = new ContainerData(){

        public int m_6413_(int pIndex) {
            return switch (pIndex) {
                case 0 -> RebrewingStandBlockEntity.this.brewProgress;
                case 1 -> RebrewingStandBlockEntity.this.fuel;
                case 2 -> RebrewingStandBlockEntity.this.cost;
                default -> 0;
            };
        }

        public void m_8050_(int pIndex, int pValue) {
            switch (pIndex) {
                case 0: {
                    RebrewingStandBlockEntity.this.brewProgress = pValue;
                    break;
                }
                case 1: {
                    RebrewingStandBlockEntity.this.fuel = pValue;
                    break;
                }
                case 2: {
                    RebrewingStandBlockEntity.this.cost = pValue;
                }
            }
        }

        public int m_6499_() {
            return 3;
        }
    };

    public RebrewingStandBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.REBREWING_STAND.get(), pPos, pBlockState);
    }

    protected Component m_6820_() {
        return Component.m_237113_((String)"");
    }

    public boolean m_7983_() {
        return this.inv.stream().allMatch(Predicate.not(ItemStack::m_41619_));
    }

    public void tick(Level level) {
        ItemStack fuelStack = (ItemStack)this.inv.get(0);
        ItemStack ogPotionStack = (ItemStack)this.inv.get(1);
        ItemStack ingredientStack = (ItemStack)this.inv.get(2);
        boolean[] potionBits = this.getPotionBits();
        this.cost = 0;
        if ((double)this.fuel < 16.0 && fuelStack.m_150930_((Item)ModItems.CROPRESSED_NETHERWART.get())) {
            ++this.fuel;
            fuelStack.m_41774_(1);
            this.m_6596_();
        }
        if (!ogPotionStack.m_41619_()) {
            List<MobEffectInstance> potionContent = this.getEffect(ogPotionStack, ingredientStack);
            int n = this.cost = potionContent != null ? 4 + (potionContent.size() - 2) * 2 : 17;
            if (this.canBrew()) {
                ++this.brewProgress;
                if (this.brewProgress >= 100) {
                    this.brew(level, ogPotionStack, ingredientStack);
                }
            }
        }
        if (!this.canBrew()) {
            this.brewProgress = 0;
        }
        if (!Arrays.equals(potionBits, this.lastPotionCount)) {
            this.bottleStateLogic(potionBits);
        }
    }

    private void brew(Level level, ItemStack ogPotionStack, ItemStack ingredientStack) {
        List<MobEffectInstance> effects = this.getEffect(ogPotionStack, ingredientStack);
        if (effects != null) {
            List index = (List)Util.m_137469_((Object)Lists.newArrayList(), integers -> integers.addAll(Arrays.asList(3, 4, 5)));
            Iterator iterator = index.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                ItemStack itemStack = (ItemStack)this.inv.get(i);
                if (itemStack.m_150930_(ItemStack.f_41583_.m_41720_())) continue;
                ItemStack outputPotion = ((Item)ModItems.REBREWED_POTION.get()).m_7968_();
                if (ingredientStack.m_150930_(Items.f_42403_)) {
                    outputPotion = ((Item)ModItems.REBREWED_SPLASH_POTION.get()).m_7968_();
                } else if (ingredientStack.m_150930_(Items.f_42735_)) {
                    outputPotion = ((Item)ModItems.REBREWED_LINGERING_POTION.get()).m_7968_();
                }
                PotionUtils.m_43552_((ItemStack)outputPotion, effects);
                this.inv.set(i, (Object)outputPotion);
            }
            ingredientStack.m_41774_(1);
            this.inv.set(1, (Object)Items.f_42590_.m_7968_());
            this.fuel -= this.cost;
            level.m_5594_(null, this.m_58899_(), SoundEvents.f_11772_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        this.brewProgress = 0;
    }

    private void bottleStateLogic(boolean[] potionBits) {
        this.lastPotionCount = potionBits;
        BlockState blockstate = this.f_58857_.m_8055_(this.m_58899_().m_7495_());
        if (!(blockstate.m_60734_() instanceof RebrewingStandBlockBase)) {
            return;
        }
        for (int i = 0; i < RebrewingStandBlockBase.HAS_BOTTLE.length; ++i) {
            blockstate = (BlockState)blockstate.m_61124_((Property)RebrewingStandBlockBase.HAS_BOTTLE[i], (Comparable)Boolean.valueOf(potionBits[i]));
        }
        this.f_58857_.m_7731_(this.m_58899_().m_7495_(), blockstate, 2);
    }

    private boolean canBrew() {
        boolean ret = false;
        boolean correctInvContent = !((ItemStack)this.inv.get(2)).m_41619_() && ((ItemStack)this.inv.get(1)).m_150930_((Item)ModItems.EXTRACTED_BOTTLE.get());
        boolean hasFuel = this.fuel >= 1 && this.fuel >= this.cost;
        boolean correctCost = this.cost <= 16;
        for (int i = 3; i <= 5; ++i) {
            if (((ItemStack)this.inv.get(i)).m_41619_() || ((ItemStack)this.inv.get(i)).m_150930_((Item)ModItems.REBREWED_POTION.get())) continue;
            ret = true;
        }
        return ret && correctInvContent && hasFuel && correctCost;
    }

    private boolean[] getPotionBits() {
        boolean[] ret = new boolean[3];
        for (int i = 3; i <= 5; ++i) {
            if (((ItemStack)this.inv.get(i)).m_41619_()) continue;
            ret[i - 3] = true;
        }
        return ret;
    }

    private List<MobEffectInstance> getEffect(ItemStack inputPotion, ItemStack ingredient) {
        ArrayList<MobEffectInstance> ret = new ArrayList<MobEffectInstance>();
        ArrayList<Integer> durList = new ArrayList<Integer>();
        ListTag listTag = (ListTag)inputPotion.m_41784_().m_128423_("CustomPotionEffects");
        int defaultAmp = 1;
        int defaultDur = 6000;
        if (listTag == null) {
            return null;
        }
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag potion = listTag.m_128728_(i);
            String id = potion.m_128461_("forge:id");
            int amp = potion.m_128445_("Amplifier") + (ingredient.m_150930_(Items.f_42525_) ? 2 : defaultAmp);
            int dur = potion.m_128451_("Duration") + (ingredient.m_150930_(Items.f_42451_) ? 12000 : defaultDur);
            String[] splitId = id.split(":");
            MobEffectInstance instance = new MobEffectInstance((MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(splitId[0], splitId[1])), dur, amp);
            durList.add(dur);
            ret.add(instance);
        }
        int maxInt = (Integer)Collections.max(durList);
        ret.add(new MobEffectInstance((MobEffect)ModMobEffects.EXTRACTED.get(), maxInt));
        return ret;
    }

    protected AbstractContainerMenu m_6555_(int pContainerId, Inventory pInventory) {
        return new RebrewingStandMenu(pContainerId, pInventory, (Container)this, this.containerData);
    }

    public int m_6643_() {
        return 6;
    }

    public ItemStack m_8020_(int pSlot) {
        return pSlot >= 0 && pSlot < this.inv.size() ? (ItemStack)this.inv.get(pSlot) : ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int pSlot, int pAmount) {
        return ContainerHelper.m_18969_(this.inv, (int)pSlot, (int)pAmount);
    }

    public ItemStack m_8016_(int pSlot) {
        return ContainerHelper.m_18966_(this.inv, (int)pSlot);
    }

    public void m_6836_(int pSlot, ItemStack pStack) {
        if (pSlot >= 0 && pSlot < this.inv.size()) {
            this.inv.set(pSlot, (Object)pStack);
        }
    }

    public boolean m_6542_(Player pPlayer) {
        return Container.m_272074_((BlockEntity)this, (Player)pPlayer);
    }

    public void m_6211_() {
        this.inv.clear();
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        ContainerHelper.m_18973_((CompoundTag)pTag, this.inv);
        pTag.m_128344_("progress", (byte)this.brewProgress);
        pTag.m_128344_("fuel", (byte)this.fuel);
        pTag.m_128344_("cost", (byte)this.cost);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.inv = NonNullList.m_122780_((int)6, (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)pTag, this.inv);
        this.fuel = pTag.m_128445_("fuel");
        this.brewProgress = pTag.m_128445_("progress");
        this.cost = pTag.m_128445_("cost");
    }
}

