/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks;

import net.abraxator.moresnifferflowers.blocks.ModCropBlock;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.MultifaceSpreader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import org.jetbrains.annotations.NotNull;

public class DawnberryVineBlock
extends MultifaceBlock
implements BonemealableBlock,
ModCropBlock,
IPlantable {
    public static final IntegerProperty AGE = BlockStateProperties.f_222999_;
    public static final BooleanProperty IS_SHEARED = BooleanProperty.m_61465_((String)"is_sheared");
    private final MultifaceSpreader spreader = new MultifaceSpreader((MultifaceBlock)this);

    public DawnberryVineBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)IS_SHEARED, (Comparable)Boolean.FALSE));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{AGE, IS_SHEARED});
    }

    @Override
    public int getAge(BlockState pState) {
        return (Integer)pState.m_61143_((Property)this.getAgeProperty());
    }

    @Override
    public int getMaxAge() {
        return (Integer)AGE.m_6908_().stream().toList().get(AGE.m_6908_().size() - 1);
    }

    @Override
    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    @Override
    public final boolean isMaxAge(BlockState pState) {
        return this.getAge(pState) >= this.getMaxAge();
    }

    public boolean m_6724_(BlockState pState) {
        return !this.isMaxAge(pState) && (Boolean)pState.m_61143_((Property)IS_SHEARED) == false;
    }

    @NotNull
    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        ItemStack itemStack = pPlayer.m_21120_(pHand);
        if (!itemStack.m_150930_(Items.f_42499_)) {
            if (itemStack.m_150930_(Items.f_42574_) && (Integer)pState.m_61143_((Property)AGE) < 4 && !((Boolean)pState.m_61143_((Property)ModStateProperties.SHEARED)).booleanValue()) {
                return this.shearAction(pState, pLevel, pPos, pPlayer, pHand, itemStack);
            }
            if (this.isMaxAge(pState)) {
                return this.dropMaxAgeLoot(pState, pLevel, pPos, pPlayer);
            }
            if ((Integer)pState.m_61143_((Property)AGE) == 3) {
                return this.dropAgeThreeLoot(pState, pLevel, pPos, pPlayer);
            }
        }
        return InteractionResult.PASS;
    }

    private InteractionResult shearAction(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack stack) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, stack);
        }
        level.m_247517_(null, pos, SoundEvents.f_184217_, SoundSource.BLOCKS);
        BlockState state = (BlockState)blockState.m_61124_((Property)IS_SHEARED, (Comparable)Boolean.valueOf((Boolean)blockState.m_61143_((Property)IS_SHEARED) == false));
        level.m_46597_(pos, state);
        level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)state));
        stack.m_41622_(1, (LivingEntity)player, o -> o.m_21190_(hand));
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    private InteractionResult dropMaxAgeLoot(BlockState blockState, Level level, BlockPos pos, Player player) {
        RandomSource randomSource = level.m_213780_();
        ItemStack DAWNBERRY = new ItemStack((ItemLike)ModItems.DAWNBERRY.get(), randomSource.m_216332_(1, 2));
        ItemStack SEEDS = new ItemStack((ItemLike)ModItems.DAWNBERRY_VINE_SEEDS.get(), randomSource.m_216332_(0, 1));
        DawnberryVineBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)DAWNBERRY);
        DawnberryVineBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)SEEDS);
        level.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
        BlockState state = (BlockState)blockState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(2));
        level.m_7731_(pos, state, 2);
        level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)state));
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    private InteractionResult dropAgeThreeLoot(BlockState blockState, Level level, BlockPos pos, Player player) {
        ItemStack DAWNBERRY = new ItemStack((ItemLike)ModItems.DAWNBERRY.get());
        DawnberryVineBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)DAWNBERRY);
        level.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
        BlockState state = (BlockState)blockState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(2));
        level.m_7731_(pos, state, 2);
        level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)state));
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    protected void grow(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        float f;
        if (!this.isMaxAge(pState) && ForgeHooks.onCropsGrowPre((Level)pLevel, (BlockPos)pPos, (BlockState)pState, (pRandom.m_188503_((int)(25.0f / (f = this.getGrowthSpeed((Block)this, (BlockGetter)pLevel, pPos))) + 1) == 0 ? 1 : 0) != 0)) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf((Integer)pState.m_61143_((Property)AGE) + 1)), 2);
            ForgeHooks.onCropsGrowPost((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!pLevel.isAreaLoaded(pPos, 1)) {
            return;
        }
        if (pLevel.m_45524_(pPos, 0) >= 9) {
            this.grow(pState, (Level)pLevel, pPos, pRandom);
        }
    }

    public MultifaceSpreader m_213612_() {
        return this.spreader;
    }

    public boolean m_7370_(LevelReader pLevel, BlockPos pPos, BlockState pState, boolean pIsClient) {
        return !this.isMaxAge(pState);
    }

    public boolean m_214167_(Level pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        return true;
    }

    public void m_214148_(ServerLevel pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        int age = this.getAge(pState);
        pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age >= 4 ? age : age + 1)), 2);
        boolean canSpread = Direction.m_235666_().anyMatch(p_153316_ -> this.spreader.m_221601_(pState, (BlockGetter)pLevel, pPos, p_153316_.m_122424_()));
        if (pRandom.m_188501_() >= 0.3f && pRandom.m_188501_() >= 0.3f && canSpread) {
            this.m_213612_().m_221619_(pState, (LevelAccessor)pLevel, pPos, pRandom);
            this.m_213612_().m_221619_(pState, (LevelAccessor)pLevel, pPos, pRandom);
        }
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return Shapes.m_83040_();
    }

    public BlockState getPlant(BlockGetter level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() != this) {
            return this.m_49966_();
        }
        return state;
    }
}

