/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks;

import net.abraxator.moresnifferflowers.blockentities.DyespriaPlantBlockEntity;
import net.abraxator.moresnifferflowers.blocks.ModCropBlock;
import net.abraxator.moresnifferflowers.blocks.ModEntityBlock;
import net.abraxator.moresnifferflowers.colors.Dye;
import net.abraxator.moresnifferflowers.init.ModAdvancementCritters;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DyespriaPlantBlock
extends BushBlock
implements ModCropBlock,
ModEntityBlock {
    public static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public DyespriaPlantBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0))).m_61124_((Property)ModStateProperties.SHEARED, (Comparable)Boolean.valueOf(false))).m_61124_(ModStateProperties.COLOR, (Comparable)DyeColor.WHITE));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{this.getAgeProperty()}).m_61104_(new Property[]{ModStateProperties.COLOR}).m_61104_(new Property[]{ModStateProperties.SHEARED});
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        if (pPlacer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pPlacer;
            ModAdvancementCritters.PLACED_DYESPRIA_PLANT.m_222618_(serverPlayer);
        }
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity blockEntity;
        ItemStack stack = pPlayer.m_21120_(pHand);
        if (this.isMaxAge(pState) && (blockEntity = pLevel.m_7702_(pPos)) instanceof DyespriaPlantBlockEntity) {
            DyespriaPlantBlockEntity entity = (DyespriaPlantBlockEntity)blockEntity;
            if (stack.m_41720_() instanceof DyeItem) {
                return this.addDye(stack, pPlayer, pLevel, entity);
            }
            if (stack.m_150930_(Items.f_42574_)) {
                this.shear(pPlayer, pLevel, pPos, pState, pHand);
                return InteractionResult.m_19078_((boolean)pLevel.m_5776_());
            }
            pPlayer.m_36356_(Dye.stackFromDye(entity.removeDye()));
            return InteractionResult.m_19078_((boolean)pLevel.m_5776_());
        }
        return InteractionResult.PASS;
    }

    private InteractionResult addDye(ItemStack dye, Player player, Level level, DyespriaPlantBlockEntity entity) {
        if (!level.f_46443_) {
            ItemStack stack = dye.m_41777_();
            dye.m_41764_(-1);
            player.m_36356_(entity.add(null, entity.dye, stack));
        }
        level.m_5594_(null, entity.m_58899_(), SoundEvents.f_144133_, SoundSource.BLOCKS, 1.0f, (float)(1.0 + (double)level.f_46441_.m_188501_() * 0.2));
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return this.m_7898_(pState, (LevelReader)pLevel, pCurrentPos) ? pState : Blocks.f_50016_.m_49966_();
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return this.mayPlaceOn(pLevel.m_8055_(pPos.m_7495_()));
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        BlockEntity blockEntity;
        if (!pState.m_60713_(pNewState.m_60734_()) && (blockEntity = pLevel.m_7702_(pPos)) instanceof DyespriaPlantBlockEntity) {
            DyespriaPlantBlockEntity entity = (DyespriaPlantBlockEntity)blockEntity;
            if (this.isMaxAge(pState)) {
                ItemStack dyespria = ((Item)ModItems.DYESPRIA.get()).m_7968_();
                ItemStack dye = new ItemStack((ItemLike)DyeItem.m_41082_((DyeColor)entity.dye.color()), entity.dye.amount());
                Containers.m_18992_((Level)pLevel, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), (ItemStack)dyespria);
                Containers.m_18992_((Level)pLevel, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), (ItemStack)dye);
            }
        }
        super.m_6810_(pState, pLevel, pPos, pNewState, pMovedByPiston);
    }

    @Override
    public boolean mayPlaceOn(BlockState pState) {
        return pState.m_204336_(BlockTags.f_144274_) && !(pState.m_60734_() instanceof FarmBlock);
    }

    @Override
    public IntegerProperty getAgeProperty() {
        return ModStateProperties.AGE_3;
    }

    public boolean m_6724_(BlockState pState) {
        return this.isMaxAge(pState);
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        this.makeGrowOnTick((Block)this, pState, (Level)pLevel, pPos);
    }

    public boolean m_7370_(LevelReader levelReader, BlockPos blockPos, BlockState blockState, boolean b) {
        return !this.isMaxAge(blockState);
    }

    public boolean m_214167_(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void m_214148_(ServerLevel pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        this.makeGrowOnBonemeal((Level)pLevel, pPos, pState);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new DyespriaPlantBlockEntity(pPos, pState);
    }
}

