/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks;

import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;

public interface ModCropBlock
extends IPlantable,
BonemealableBlock {
    public IntegerProperty getAgeProperty();

    default public boolean isMaxAge(BlockState blockState) {
        return this.getAge(blockState) >= this.getMaxAge();
    }

    default public int getMaxAge() {
        return (Integer)this.getAgeProperty().m_6908_().stream().toList().get(this.getAgeProperty().m_6908_().size() - 1);
    }

    default public int getAge(BlockState blockState) {
        return (Integer)blockState.m_61143_((Property)this.getAgeProperty());
    }

    default public void makeGrowOnTick(Block block, BlockState blockState, Level level, BlockPos blockPos) {
        if (!this.isMaxAge(blockState) && level.isAreaLoaded(blockPos, 1) && level.m_45524_(blockPos, 0) >= 9) {
            float f = this.getGrowthSpeed(block, (BlockGetter)level, blockPos);
            if (ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)blockPos, (BlockState)blockState, (level.m_213780_().m_188503_((int)(25.0f / f) + 1) == 0 ? 1 : 0) != 0)) {
                level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf((Integer)blockState.m_61143_((Property)this.getAgeProperty()) + 1)), 2);
                ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)blockPos, (BlockState)blockState);
            }
        }
    }

    default public void makeGrowOnBonemeal(Level level, BlockPos blockPos, BlockState blockState) {
        level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(this.getAge(blockState) >= 3 ? this.getAge(blockState) : this.getAge(blockState) + 1)), 2);
    }

    default public boolean mayPlaceOn(BlockState pState) {
        return pState.m_60713_(Blocks.f_50093_) || pState.m_60734_() instanceof FarmBlock || pState.m_204336_(TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("supplementaries", "planters")));
    }

    default public void shear(Player player, Level level, BlockPos blockPos, BlockState blockState, InteractionHand hand) {
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.f_10562_.m_285767_((ServerPlayer)player, blockPos, player.m_21120_(hand));
        }
        level.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)ModStateProperties.SHEARED, (Comparable)Boolean.valueOf(true)));
        level.m_5594_(null, blockPos, SoundEvents.f_184217_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
        level.m_220407_(GameEvent.f_157792_, blockPos, GameEvent.Context.m_223719_((Entity)player, (BlockState)level.m_8055_(blockPos)));
        player.m_21120_(hand).m_41622_(1, (LivingEntity)player, player1 -> player1.m_21190_(hand));
    }

    default public float getGrowthSpeed(Block pBlock, BlockGetter pLevel, BlockPos pPos) {
        boolean flag1;
        float f = 1.0f;
        BlockPos blockpos = pPos.m_7495_();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                BlockState blockstate = pLevel.m_8055_(blockpos.m_7918_(i, 0, j));
                if (blockstate.canSustainPlant(pLevel, blockpos.m_7918_(i, 0, j), Direction.UP, (IPlantable)pBlock)) {
                    f1 = 1.0f;
                    if (blockstate.isFertile(pLevel, pPos.m_7918_(i, 0, j))) {
                        f1 = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        BlockPos blockpos1 = pPos.m_122012_();
        BlockPos blockpos2 = pPos.m_122019_();
        BlockPos blockpos3 = pPos.m_122024_();
        BlockPos blockpos4 = pPos.m_122029_();
        boolean flag = pLevel.m_8055_(blockpos3).m_60713_(pBlock) || pLevel.m_8055_(blockpos4).m_60713_(pBlock);
        boolean bl = flag1 = pLevel.m_8055_(blockpos1).m_60713_(pBlock) || pLevel.m_8055_(blockpos2).m_60713_(pBlock);
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = pLevel.m_8055_(blockpos3.m_122012_()).m_60713_(pBlock) || pLevel.m_8055_(blockpos4.m_122012_()).m_60713_(pBlock) || pLevel.m_8055_(blockpos4.m_122019_()).m_60713_(pBlock) || pLevel.m_8055_(blockpos3.m_122019_()).m_60713_(pBlock);
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f;
    }

    public record PosAndState(BlockPos blockPos, BlockState state) {
    }
}

