/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks.ambush;

import net.abraxator.moresnifferflowers.blockentities.AmbushBlockEntity;
import net.abraxator.moresnifferflowers.blocks.ModCropBlock;
import net.abraxator.moresnifferflowers.blocks.ModEntityDoubleTallBlock;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.abraxator.moresnifferflowers.init.ModParticles;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class AmbushBlockBase
extends ModEntityDoubleTallBlock
implements ModCropBlock {
    public static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final int AGE_TO_GROW_UP = 4;

    public AmbushBlockBase(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @Override
    public IntegerProperty getAgeProperty() {
        return ModStateProperties.AGE_8;
    }

    public boolean m_6724_(BlockState pState) {
        return !this.isMaxAge(pState);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        BlockEntity blockEntity;
        if (this.isUpper(pState) && (blockEntity = pLevel.m_7702_(pPos)) instanceof AmbushBlockEntity) {
            AmbushBlockEntity entity = (AmbushBlockEntity)blockEntity;
            if (entity.hasGrown) {
                return super.m_5940_(pState, pLevel, pPos, pContext);
            }
        }
        return SHAPE;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return this.m_49966_();
    }

    @Override
    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return this.mayPlaceOn(pLevel.m_8055_(pPos.m_7495_())) && this.sufficientLight(pLevel, pPos) && super.m_7898_(pState, pLevel, pPos);
    }

    @Override
    public boolean mayPlaceOn(BlockState pState) {
        return ModCropBlock.super.mayPlaceOn(pState) || pState.m_60713_((Block)ModBlocks.REBREWING_STAND_BOTTOM.get());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{ModStateProperties.AGE_8});
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (pEntity instanceof Ravager && pLevel.m_46469_().m_46207_(GameRules.f_46132_)) {
            pLevel.m_46953_(pPos, true, pEntity);
        }
        super.m_7892_(pState, pLevel, pPos, pEntity);
    }

    public boolean m_6864_(BlockState pState, BlockPlaceContext pUseContext) {
        return false;
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if (this.getAge(pState) == 7 && pRandom.m_188503_(100) < 10 && this.isLower(pState)) {
            double dx = (double)pPos.m_123341_() + pRandom.m_188500_();
            double dy = (double)pPos.m_123342_() + pRandom.m_188500_();
            double dz = (double)pPos.m_123343_() + pRandom.m_188500_();
            pLevel.m_7106_((ParticleOptions)ModParticles.AMBUSH.get(), dx, dy, dz, 0.0, 0.0, 0.0);
        }
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        float f = this.getGrowthSpeed(this, (BlockGetter)pLevel, pPos);
        if (pRandom.m_188503_((int)(25.0f / f + 1.0f)) == 0) {
            this.grow(pLevel, pState, pPos, 1);
        }
    }

    public void grow(ServerLevel pLevel, BlockState pState, BlockPos pPos, int i) {
        int k = Math.min(this.getAge(pState) + i, this.getMaxAge());
        if (this.canGrow((LevelReader)pLevel, pPos, pState, k)) {
            BlockEntity blockEntity;
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(k)), 2);
            if (k >= 4 && this.isLower(pState)) {
                pLevel.m_7731_(pPos.m_7494_(), (BlockState)((Block)ModBlocks.AMBUSH_TOP.get()).m_49966_().m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(k)), 3);
            }
            if ((blockEntity = pLevel.m_7702_(this.getLowerHalf((LevelReader)pLevel, pPos, pState).blockPos().m_7494_())) instanceof AmbushBlockEntity) {
                AmbushBlockEntity entity = (AmbushBlockEntity)blockEntity;
                entity.growProgress = 0.0f;
            }
        }
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity blockEntity = pLevel.m_7702_(this.getLowerHalf((LevelReader)pLevel, pPos, pState).blockPos().m_7494_());
        if (blockEntity instanceof AmbushBlockEntity) {
            AmbushBlockEntity entity = (AmbushBlockEntity)blockEntity;
            if (entity.hasGrown) {
                BlockPos lowerPos = this.isLower(pState) ? pPos : pPos.m_7495_();
                pLevel.m_5594_(null, pPos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + pLevel.f_46441_.m_188501_() * 0.4f);
                AmbushBlockBase.m_49840_((Level)pLevel, (BlockPos)pPos, (ItemStack)new ItemStack((ItemLike)ModBlocks.AMBER.get()));
                pLevel.m_5594_(null, pPos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + pLevel.f_46441_.m_188501_() * 0.4f);
                for (int i = 0; i <= 1; ++i) {
                    BlockPos halfPos = i == 0 ? lowerPos : lowerPos.m_7494_();
                    BlockState state = (BlockState)pLevel.m_8055_(halfPos).m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(7));
                    pLevel.m_7731_(halfPos, state, 3);
                    pLevel.m_220407_(GameEvent.f_157792_, halfPos, GameEvent.Context.m_223719_((Entity)pPlayer, (BlockState)state));
                }
                entity.reset();
                return InteractionResult.m_19078_((boolean)pLevel.m_5776_());
            }
        }
        return InteractionResult.PASS;
    }

    private boolean canGrowInto(BlockState state) {
        return state.m_60795_() || state.m_60713_((Block)ModBlocks.AMBUSH_TOP.get());
    }

    private boolean sufficientLight(LevelReader pLevel, BlockPos pPos) {
        return pLevel.m_45524_(pPos, 0) >= 8 || pLevel.m_45527_(pPos);
    }

    @Override
    public int getMaxAge() {
        return ModCropBlock.super.getMaxAge() - 1;
    }

    private boolean canGrow(LevelReader pLevel, BlockPos pPos, BlockState pState, int k) {
        return !this.isMaxAge(pState) && this.sufficientLight(pLevel, pPos) && (k < 4 || this.canGrowInto(pLevel.m_8055_(pPos.m_7494_()))) && this.isLower(pState);
    }

    private ModCropBlock.PosAndState getLowerHalf(LevelReader level, BlockPos blockPos, BlockState state) {
        if (this.isLower(state)) {
            return new ModCropBlock.PosAndState(blockPos, state);
        }
        BlockPos posBelow = blockPos.m_7495_();
        BlockState stateBelow = level.m_8055_(posBelow);
        return this.isLower(stateBelow) ? new ModCropBlock.PosAndState(posBelow, stateBelow) : null;
    }

    public boolean m_7370_(LevelReader levelReader, BlockPos blockPos, BlockState blockState, boolean b) {
        ModCropBlock.PosAndState posAndState = this.getLowerHalf(levelReader, blockPos, blockState);
        return posAndState != null && this.canGrow(levelReader, posAndState.blockPos(), posAndState.state(), this.getAge(posAndState.state()) + 1);
    }

    public boolean m_214167_(Level pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        return true;
    }

    public void m_214148_(ServerLevel pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        ModCropBlock.PosAndState posAndState = this.getLowerHalf((LevelReader)pLevel, pPos, pState);
        if (posAndState != null && (Integer)pState.m_61143_((Property)ModStateProperties.AGE_8) < 8) {
            this.grow(pLevel, posAndState.state(), posAndState.blockPos(), 1);
        }
    }

    @Override
    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return ((Item)ModItems.AMBUSH_SEEDS.get()).m_7968_();
    }

    @Override
    public Block getLowerBlock() {
        return (Block)ModBlocks.AMBUSH_BOTTOM.get();
    }

    @Override
    public Block getUpperBlock() {
        return (Block)ModBlocks.AMBUSH_TOP.get();
    }

    public BlockState getPlant(BlockGetter blockGetter, BlockPos blockPos) {
        return blockGetter.m_8055_(blockPos);
    }
}

