/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.blocks.cropressor;

import net.abraxator.moresnifferflowers.blockentities.CropressorBlockEntity;
import net.abraxator.moresnifferflowers.blocks.cropressor.CropressorBlockOut;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CropressorBlockBase
extends HorizontalDirectionalBlock {
    public final Part PART;
    protected BlockPos ENTITY_POS;
    protected static final VoxelShape OUT_EAST = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)16.0, (double)10.0, (double)14.0);
    protected static final VoxelShape OUT_SOUTH = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)16.0);
    protected static final VoxelShape OUT_WEST = Block.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0);
    protected static final VoxelShape OUT_NORTH = Block.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)10.0, (double)14.0);
    protected static final VoxelShape CENTER_EAST = Block.m_49796_((double)1.0, (double)0.0, (double)2.0, (double)16.0, (double)10.0, (double)14.0);
    protected static final VoxelShape CENTER_SOUTH = Block.m_49796_((double)2.0, (double)0.0, (double)1.0, (double)14.0, (double)10.0, (double)16.0);
    protected static final VoxelShape CENTER_WEST = Block.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)15.0, (double)10.0, (double)14.0);
    protected static final VoxelShape CENTER_NORTH = Block.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)10.0, (double)15.0);

    public CropressorBlockBase(BlockBehaviour.Properties pProperties, Part part) {
        super(pProperties);
        this.PART = part;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction direction = CropressorBlockBase.getConnectedDirection(pState);
        if (pState.m_60734_() instanceof CropressorBlockOut) {
            return switch (direction) {
                case Direction.EAST -> OUT_EAST;
                case Direction.SOUTH -> OUT_SOUTH;
                case Direction.WEST -> OUT_WEST;
                default -> OUT_NORTH;
            };
        }
        return switch (direction) {
            case Direction.EAST -> CENTER_EAST;
            case Direction.SOUTH -> CENTER_SOUTH;
            case Direction.WEST -> CENTER_WEST;
            default -> CENTER_NORTH;
        };
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{f_54117_});
    }

    private Direction getNeighbourDirection(Part part, Direction direction) {
        return part == Part.OUT ? direction : direction.m_122424_();
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        if (pDirection == this.getNeighbourDirection(this.PART, (Direction)pState.m_61143_((Property)f_54117_))) {
            boolean b1;
            boolean b = pNeighborState.m_60734_() instanceof CropressorBlockBase;
            boolean bl = b1 = CropressorBlockBase.getPartFromState(pNeighborState) != this.PART;
            if (b && b1) {
                return super.m_7417_(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
            }
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        Direction direction = pContext.m_8125_();
        BlockPos blockPos = pContext.m_8083_();
        BlockPos blockPos1 = blockPos.m_121945_(direction);
        Level level = pContext.m_43725_();
        return level.m_8055_(blockPos1).m_60629_(pContext) && level.m_6857_().m_61937_(blockPos1) ? (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction) : null;
    }

    public static Direction getConnectedDirection(BlockState pState) {
        Direction direction = (Direction)pState.m_61143_((Property)f_54117_);
        return CropressorBlockBase.getPartFromState(pState) == Part.CENTER ? direction.m_122424_() : direction;
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        if (!pLevel.f_46443_) {
            BlockPos blockPos = pPos.m_121945_((Direction)pState.m_61143_((Property)f_54117_));
            pLevel.m_7731_(blockPos, (BlockState)((Block)ModBlocks.CROPRESSOR_CENTER.get()).m_49966_().m_61124_((Property)f_54117_, (Comparable)((Direction)pState.m_61143_((Property)f_54117_))), 3);
            pLevel.m_6289_(pPos, Blocks.f_50016_);
            pState.m_60701_((LevelAccessor)pLevel, pPos, 3);
        }
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        CropressorBlockEntity entity;
        BlockEntity blockEntity;
        BlockPos blockPos = this.ENTITY_POS = this.PART == Part.OUT ? pPos : this.getEntityPos(pLevel, pPos);
        if (!pLevel.f_46443_ && (blockEntity = pLevel.m_7702_(this.ENTITY_POS)) instanceof CropressorBlockEntity && (entity = (CropressorBlockEntity)blockEntity).canInteract() && pPlayer.m_21205_().m_204117_(ModTags.ModItemTags.CROPRESSABLE_CROPS)) {
            ItemStack itemInHand = pPlayer.m_21120_(pHand);
            ItemStack itemToAddToPlayer = entity.addItem(itemInHand, pLevel);
            pPlayer.m_36356_(itemToAddToPlayer);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private BlockPos getEntityPos(Level level, BlockPos blockPos) {
        if (this.PART == Part.OUT) {
            return blockPos;
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!(level.m_7702_(blockPos.m_121945_(direction)) instanceof CropressorBlockEntity)) continue;
            return blockPos.m_121945_(direction);
        }
        return null;
    }

    public static Part getPartFromState(BlockState blockState) {
        Part part;
        Block block = blockState.m_60734_();
        if (block instanceof CropressorBlockBase) {
            CropressorBlockBase baseCropressorBlock = (CropressorBlockBase)block;
            part = baseCropressorBlock.PART;
        } else {
            part = null;
        }
        return part;
    }

    public static enum Part implements StringRepresentable
    {
        CENTER("center"),
        OUT("out");

        private String name;

        private Part(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

