/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.client.gui.screen;

import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public class ModCyclingSlotBackground {
    private static final int ICON_CHANGE_TICK_RATE = 30;
    private static final int ICON_SIZE = 16;
    private static final int ICON_TRANSITION_TICK_DURATION = 4;
    private final int slotIndex;
    private List<ResourceLocation> icons = List.of();
    private int tick;
    private int iconIndex;

    public ModCyclingSlotBackground(int pSlotIndex) {
        this.slotIndex = pSlotIndex;
    }

    public void tick(List<ResourceLocation> pIcons) {
        if (!this.icons.equals(pIcons)) {
            this.icons = pIcons;
            this.iconIndex = 0;
        }
        if (!this.icons.isEmpty() && ++this.tick % 30 == 0) {
            this.iconIndex = (this.iconIndex + 1) % this.icons.size();
        }
    }

    public void render(AbstractContainerMenu pContainerMenu, GuiGraphics pGuiGraphics, float pPartialTick, int pX, int pY) {
        Slot slot = pContainerMenu.m_38853_(this.slotIndex);
        if (!this.icons.isEmpty() && !slot.m_6657_()) {
            float f;
            boolean flag = this.icons.size() > 1 && this.tick >= 30;
            float f2 = f = flag ? this.getIconTransitionTransparency(pPartialTick) : 1.0f;
            if (f < 1.0f) {
                int i = Math.floorMod(this.iconIndex - 1, this.icons.size());
                this.renderIcon(slot, this.icons.get(i), pGuiGraphics, pX, pY);
            }
            this.renderIcon(slot, this.icons.get(this.iconIndex), pGuiGraphics, pX, pY);
        }
    }

    private void renderIcon(Slot pSlot, ResourceLocation pIcon, GuiGraphics pGuiGraphics, int pX, int pY) {
        pGuiGraphics.m_280218_(pIcon, pX + pSlot.f_40220_, pY + pSlot.f_40221_, 0, 0, 16, 16);
    }

    private float getIconTransitionTransparency(float pPartialTick) {
        float f = (float)(this.tick % 30) + pPartialTick;
        return Math.min(f, 4.0f) / 4.0f;
    }
}

