/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.abraxator.moresnifferflowers.MoreSnifferFlowers;
import net.abraxator.moresnifferflowers.blockentities.GiantCropBlockEntity;
import net.abraxator.moresnifferflowers.blocks.GiantCropBlock;
import net.abraxator.moresnifferflowers.client.model.ModModelLayerLocations;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModTags;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Quaternionf;

public class GiantCropBlockEntityRenderer<T extends GiantCropBlockEntity>
implements BlockEntityRenderer<T> {
    private final EntityRenderDispatcher entityRenderDispatcher;
    private final Map<Block, ModelPart> modelPartMap = new HashMap<Block, ModelPart>();
    private final ModelPart carrot;
    private final ModelPart potato;
    private final ModelPart netherwart;
    private final ModelPart beetroot;
    private final ModelPart wheat;

    public GiantCropBlockEntityRenderer(BlockEntityRendererProvider.Context pContext) {
        this.entityRenderDispatcher = pContext.m_234446_();
        ModelPart carrotModelPart = pContext.m_173582_(ModModelLayerLocations.GIANT_CARROT);
        this.carrot = carrotModelPart.m_171324_("root");
        this.modelPartMap.put((Block)ModBlocks.GIANT_CARROT.get(), this.carrot);
        ModelPart potatoModelPart = pContext.m_173582_(ModModelLayerLocations.GIANT_POTATO);
        this.potato = potatoModelPart.m_171324_("root");
        this.modelPartMap.put((Block)ModBlocks.GIANT_POTATO.get(), this.potato);
        ModelPart netherwartModelPart = pContext.m_173582_(ModModelLayerLocations.GIANT_NETHERWART);
        this.netherwart = netherwartModelPart.m_171324_("root");
        this.modelPartMap.put((Block)ModBlocks.GIANT_NETHERWART.get(), this.netherwart);
        ModelPart beetrootModelPart = pContext.m_173582_(ModModelLayerLocations.GIANT_BEETROOT);
        this.beetroot = beetrootModelPart.m_171324_("root");
        this.modelPartMap.put((Block)ModBlocks.GIANT_BEETROOT.get(), this.beetroot);
        ModelPart wheatModelPart = pContext.m_173582_(ModModelLayerLocations.GIANT_WHEAT);
        this.wheat = wheatModelPart.m_171324_("root");
        this.modelPartMap.put((Block)ModBlocks.GIANT_WHEAT.get(), this.wheat);
    }

    public void render(GiantCropBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        BlockState blockState = pBlockEntity.m_58900_();
        String path = blockState.m_60734_().m_7705_().replace("block.moresnifferflowers.", "");
        Material TEXTURE = new Material(TextureAtlas.f_118259_, MoreSnifferFlowers.loc("block/" + path));
        VertexConsumer vertexConsumer = TEXTURE.m_119194_(pBufferSource, RenderType::m_110452_);
        if (pBlockEntity.growProgress > 0.0 && blockState.m_204336_(ModTags.ModBlockTags.GIANT_CROPS) && !((GiantCropBlock.ModelPos)((Object)blockState.m_61143_(GiantCropBlock.MODEL_POSITION))).equals((Object)GiantCropBlock.ModelPos.NONE)) {
            GiantCropBlock.ModelPos modelPos = (GiantCropBlock.ModelPos)((Object)blockState.m_61143_(GiantCropBlock.MODEL_POSITION));
            pPoseStack.m_85836_();
            pPoseStack.m_85837_(modelPos.x, modelPos.y - 2.0 + pBlockEntity.growProgress * 2.0, modelPos.z);
            double delta = Math.min(pBlockEntity.growProgress * (double)pPartialTick, 1.0);
            pPoseStack.m_85841_(1.0f, (float)Math.min(Mth.m_14139_((double)(pBlockEntity.growProgress + (double)pPartialTick), (double)0.0, (double)1.0), pBlockEntity.growProgress), 1.0f);
            pPoseStack.m_252781_(new Quaternionf().rotateX((float)Math.PI));
            this.modelPartMap.get(blockState.m_60734_()).m_104301_(pPoseStack, vertexConsumer, pPackedLight, pPackedOverlay);
            pPoseStack.m_85849_();
        }
    }

    private Double getLowest(List<Double> list) {
        double ret = 0.0;
        for (double num : list) {
            if (!(num < ret)) continue;
            ret = num;
        }
        return ret;
    }
}

