/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.colors;

import net.abraxator.moresnifferflowers.colors.Colorable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public record Dye(DyeColor color, int amount) {
    public static final Dye EMPTY = new Dye(DyeColor.WHITE, 0);

    public boolean isEmpty() {
        return this.amount <= 0;
    }

    public static Dye getDyeFromDyeStack(ItemStack dyeStack) {
        return new Dye(((DyeItem)dyeStack.m_41720_()).m_41089_(), dyeStack.m_41613_());
    }

    public static Dye getDyeFromStack(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41784_();
        int colorId = tag.m_128451_("color");
        int amount = tag.m_128451_("amount");
        return new Dye(DyeColor.m_41053_((int)colorId), amount);
    }

    public static ItemStack stackFromDye(Dye dye) {
        return dye.isEmpty() ? ItemStack.f_41583_ : new ItemStack((ItemLike)DyeItem.m_41082_((DyeColor)dye.color), dye.amount);
    }

    public static boolean dyeCheck(Dye dye, ItemStack dyeToInsert) {
        DyeItem dyeToInsertItem = (DyeItem)dyeToInsert.m_41720_();
        return dye.color.equals((Object)dyeToInsertItem.m_41089_());
    }

    public static int colorForDye(Colorable colorable, DyeColor dyeColor) {
        return colorable.colorValues().getOrDefault(dyeColor, -1);
    }

    public static void setDyeToStack(ItemStack stack, ItemStack dyeToInsert, int amount) {
        DyeColor dyeColor = dyeToInsert.m_41720_() instanceof DyeItem ? ((DyeItem)dyeToInsert.m_41720_()).m_41089_() : DyeColor.WHITE;
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("color", dyeColor.m_41060_());
        tag.m_128405_("amount", amount);
        stack.m_41751_(tag);
    }

    public static void setDyeColorToStack(ItemStack stack, DyeColor color, int amount) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("color", color.m_41060_());
        tag.m_128405_("amount", amount);
        stack.m_41751_(tag);
    }
}

