/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.entities;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import net.abraxator.moresnifferflowers.init.ModEntityTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Bobling
extends Animal {
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_MODULE_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26383_);
    public static final EntityDataAccessor<Long> LAST_POSE_CHANGE_TICK = SynchedEntityData.m_135353_(Bobling.class, (EntityDataSerializer)EntityDataSerializers.f_244073_);
    public final AnimationState sitDownAnimationState = new AnimationState();
    public final AnimationState sitPoseAnimationState = new AnimationState();
    public final AnimationState standUpAnimationState = new AnimationState();
    private static final EntityDimensions SITTING_DIMENSION = EntityDimensions.m_20395_((float)((EntityType)ModEntityTypes.BOBLING.get()).m_20678_(), (float)(((EntityType)ModEntityTypes.BOBLING.get()).m_20679_() - 0.6f));

    public Bobling(EntityType<? extends Bobling> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21342_ = new BoblingMoveControl();
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128356_("LastPoseTick", ((Long)this.f_19804_.m_135370_(LAST_POSE_CHANGE_TICK)).longValue());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        long i = pCompound.m_128454_("LastPoseTick");
        if (i < 0L) {
            this.m_20124_(Pose.SITTING);
        }
        this.resetLastPoseChangeTick(i);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Bobling.m_21183_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, (double)0.8f).m_22268_(Attributes.f_22277_, 10.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LAST_POSE_CHANGE_TICK, (Object)0L);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.resetLastPoseChangeTickToFullStand(pLevel.m_6018_().m_46467_());
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    protected Brain.Provider<Bobling> m_5490_() {
        return Brain.m_21923_(MEMORY_MODULE_TYPES, (Collection)ImmutableList.of());
    }

    protected void m_8099_() {
    }

    public EntityDimensions m_6972_(Pose pPose) {
        return pPose == Pose.SITTING ? SITTING_DIMENSION.m_20388_(this.m_6134_()) : super.m_6972_(pPose);
    }

    protected void m_8024_() {
        this.m_9236_().m_46473_().m_6180_("BoblingBrain");
        Brain brain = this.m_6274_();
        brain.m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)this);
        this.m_9236_().m_46473_().m_7238_();
        this.m_9236_().m_46473_().m_6180_("BoblingActivityUpdate");
        this.m_9236_().m_46473_().m_7238_();
        super.m_8024_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.refuseToMove()) {
            this.clampHeadRotationToBody((Entity)this, 30.0f);
        }
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        if (this.isBoblingVisuallySitting()) {
            this.standUpAnimationState.m_216973_();
            if (this.isVisuallySittingDown()) {
                this.sitDownAnimationState.m_216982_(this.f_19797_);
                this.sitPoseAnimationState.m_216973_();
            } else {
                this.sitDownAnimationState.m_216973_();
                this.sitPoseAnimationState.m_216982_(this.f_19797_);
            }
        } else {
            this.sitDownAnimationState.m_216973_();
            this.sitPoseAnimationState.m_216973_();
            this.standUpAnimationState.m_246184_(this.isInPoseTransition() && this.getPoseTime() >= 0L, this.f_19797_);
        }
    }

    public void m_267689_(float f) {
        float f2 = this.m_20089_() == Pose.STANDING ? Math.min(f * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f2, 0.2f);
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.refuseToMove() && this.m_20096_()) {
            Vec3 vec3 = new Vec3(0.0, 1.0, 0.0);
            this.m_20256_(this.m_20184_().m_82559_(vec3));
            pTravelVector = pTravelVector.m_82559_(vec3);
        }
        super.m_7023_(pTravelVector);
    }

    public boolean refuseToMove() {
        return this.isBoblingSitting() || this.isInPoseTransition();
    }

    public boolean m_35506_() {
        return false;
    }

    public boolean m_264410_() {
        return true;
    }

    public boolean isPanicking() {
        return this.m_6274_().m_21876_(MemoryModuleType.f_217768_, MemoryStatus.VALUE_PRESENT);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    public boolean isBoblingSitting() {
        return (Long)this.f_19804_.m_135370_(LAST_POSE_CHANGE_TICK) < 0L;
    }

    public boolean isBoblingVisuallySitting() {
        return this.getPoseTime() < 0L != this.isBoblingSitting();
    }

    public boolean isInPoseTransition() {
        long i = this.getPoseTime();
        return i < (long)(this.isBoblingSitting() ? 40 : 52);
    }

    public long getPoseTime() {
        return (long)((float)this.m_9236_().m_46467_() - Mth.m_14154_((float)((Long)this.f_19804_.m_135370_(LAST_POSE_CHANGE_TICK)).longValue()));
    }

    private boolean isVisuallySittingDown() {
        return this.isBoblingSitting() && this.getPoseTime() < 40L && this.getPoseTime() >= 0L;
    }

    public void sitDown() {
        if (!this.isBoblingSitting()) {
            this.m_5496_(SoundEvents.f_244086_, 1.0f, 1.0f);
            this.m_20124_(Pose.SITTING);
            this.resetLastPoseChangeTick(-this.m_9236_().m_46467_());
        }
    }

    public void standUp() {
        if (this.isBoblingSitting()) {
            this.m_5496_(SoundEvents.f_244044_, 1.0f, 1.0f);
            this.m_20124_(Pose.STANDING);
            this.resetLastPoseChangeTick(this.m_9236_().m_46467_());
        }
    }

    public void standUpInstantly() {
        this.m_20124_(Pose.STANDING);
        this.resetLastPoseChangeTickToFullStand(this.m_9236_().m_46467_());
    }

    @VisibleForTesting
    public void resetLastPoseChangeTick(long pLastPoseChangeTick) {
        this.f_19804_.m_135381_(LAST_POSE_CHANGE_TICK, (Object)pLastPoseChangeTick);
    }

    private void resetLastPoseChangeTickToFullStand(long p_265447_) {
        this.resetLastPoseChangeTick(Math.max(0L, p_265447_ - 52L - 1L));
    }

    protected void m_6475_(DamageSource pDamageSource, float pDamageAmount) {
        this.standUpInstantly();
        super.m_6475_(pDamageSource, pDamageAmount);
    }

    private void clampHeadRotationToBody(Entity p_265624_, float p_265541_) {
        float f = p_265624_.m_6080_();
        float f1 = Mth.m_14177_((float)(this.f_20883_ - f));
        float f2 = Mth.m_14036_((float)Mth.m_14177_((float)(this.f_20883_ - f)), (float)(-p_265541_), (float)p_265541_);
        float f3 = f + f1 - f2;
        p_265624_.m_5616_(f3);
    }

    class BoblingMoveControl
    extends MoveControl {
        public BoblingMoveControl() {
            super((Mob)Bobling.this);
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && Bobling.this.isBoblingSitting() && !Bobling.this.isInPoseTransition()) {
                Bobling.this.standUp();
            }
            super.m_8126_();
        }
    }
}

