/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.events;

import java.util.List;
import net.abraxator.moresnifferflowers.blockentities.GiantCropBlockEntity;
import net.abraxator.moresnifferflowers.init.ModAdvancementCritters;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModItems;
import net.abraxator.moresnifferflowers.init.ModParticles;
import net.abraxator.moresnifferflowers.init.ModTags;
import net.abraxator.moresnifferflowers.items.JarOfBonmeelItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="moresnifferflowers", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ForgeEvents {
    @SubscribeEvent
    public static void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack itemStack = event.getEntity().m_21120_(event.getHand()).m_41720_().m_7968_();
        BlockState block = event.getLevel().m_8055_(event.getPos());
        if (itemStack.m_41720_() instanceof JarOfBonmeelItem && block.m_204336_(ModTags.ModBlockTags.BONMEELABLE)) {
            UseOnContext context = new UseOnContext(event.getLevel(), event.getEntity(), event.getHand(), event.getItemStack(), event.getHitVec());
            event.setCanceled(true);
            ((JarOfBonmeelItem)itemStack.m_41720_()).m_6225_(context);
        } else if ((itemStack.m_150930_((Item)ModItems.REBREWED_POTION.get()) || itemStack.m_150930_((Item)ModItems.EXTRACTED_BOTTLE.get())) && block.m_60713_(Blocks.f_50493_)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        LevelAccessor levelAccessor;
        if (event.getState().m_60713_((Block)ModBlocks.AMBER.get()) && (levelAccessor = event.getLevel()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            ForgeEvents.fireFlyLogic(event.getState(), serverLevel, event.getPos(), event.getPlayer(), (Event)event);
        }
        if ((levelAccessor = event.getLevel().m_7702_(event.getPos())) instanceof GiantCropBlockEntity) {
            GiantCropBlockEntity entity = (GiantCropBlockEntity)levelAccessor;
            BlockPos.m_121940_((BlockPos)entity.pos1, (BlockPos)entity.pos2).forEach(blockPos -> event.getLevel().m_46961_(blockPos, true));
        }
    }

    @SubscribeEvent
    public static void onGetAdvancement(AdvancementEvent.AdvancementEarnEvent event) {
        Player player;
        if (event.getAdvancement().m_138327_().equals((Object)new ResourceLocation("minecraft", "husbandry/obtain_sniffer_egg")) && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ModAdvancementCritters.EARN_SNIFFER_ADVANCEMENT.m_222618_(serverPlayer);
        }
    }

    private static void fireFlyLogic(BlockState state, ServerLevel serverLevel, BlockPos pos, Player player, Event event) {
        List list = Block.m_49874_((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)serverLevel.m_7702_(pos), (Entity)player, (ItemStack)player.m_21205_());
        RandomSource randomSource = serverLevel.m_213780_();
        if (randomSource.m_188503_(list.size()) == list.size()) {
            event.setCanceled(true);
            serverLevel.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 10, 0.0, 0.0, 0.0, 0.0);
            Vec3 vecPos = pos.m_252807_();
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.FLY.get()), vecPos.m_7096_() + (double)((randomSource.m_188503_(10) - 5) / 10), vecPos.m_7098_() + (double)((randomSource.m_188503_(10) - 5) / 10), vecPos.m_7094_() + (double)((randomSource.m_188503_(10) - 5) / 10), 0, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

