/*
 * Decompiled with CFR 0.152.
 */
package net.abraxator.moresnifferflowers.items;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.abraxator.moresnifferflowers.blockentities.DyespriaPlantBlockEntity;
import net.abraxator.moresnifferflowers.colors.Colorable;
import net.abraxator.moresnifferflowers.colors.Dye;
import net.abraxator.moresnifferflowers.init.ModAdvancementCritters;
import net.abraxator.moresnifferflowers.init.ModBlocks;
import net.abraxator.moresnifferflowers.init.ModSoundEvents;
import net.abraxator.moresnifferflowers.init.ModStateProperties;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.Nullable;

public class DyespriaItem
extends BlockItem
implements Colorable {
    public DyespriaItem(Item.Properties pProperties) {
        super((Block)ModBlocks.DYESPRIA_PLANT.get(), pProperties);
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        Player player = pContext.m_43723_();
        Level level = pContext.m_43725_();
        BlockPos blockPos = pContext.m_8083_();
        BlockState blockState = level.m_8055_(blockPos);
        ItemStack stack = pContext.m_43722_();
        boolean flag = false;
        if (pContext.m_43724_() != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        if (blockState.m_60713_((Block)ModBlocks.CAULORFLOWER.get()) && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (!player.m_6144_()) {
                    this.colorOne(stack, serverLevel, blockPos, blockState);
                } else {
                    this.colorColumn(stack, serverLevel, blockPos);
                }
                level.m_5594_(null, blockPos, (SoundEvent)ModSoundEvents.DYESPRIA_PAINT.get(), SoundSource.BLOCKS, 1.0f, (float)(1.0 + (double)level.f_46441_.m_188501_() * 0.2));
                ModAdvancementCritters.USED_DYESPRIA.m_222618_(serverPlayer);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        BlockPos posForDyespria = blockPos.m_7494_();
        BlockHitResult blockHitResult = new BlockHitResult(posForDyespria.m_7495_().m_252807_(), Direction.UP, posForDyespria.m_7495_(), false);
        UseOnContext useOnCtx = new UseOnContext(level, player, pContext.m_43724_(), stack, blockHitResult);
        InteractionResult result = super.m_6225_(useOnCtx);
        BlockEntity blockEntity = level.m_7702_(blockPos.m_7494_());
        if (blockEntity instanceof DyespriaPlantBlockEntity) {
            DyespriaPlantBlockEntity entity = (DyespriaPlantBlockEntity)blockEntity;
            entity.dye = Dye.getDyeFromStack(stack);
            entity.m_6596_();
        }
        return result;
    }

    @Nullable
    protected BlockState m_5965_(BlockPlaceContext pContext) {
        BlockState state = super.m_5965_(pContext);
        return state == null ? null : (BlockState)state.m_61124_((Property)ModStateProperties.AGE_3, (Comparable)Integer.valueOf(3));
    }

    public void colorOne(ItemStack stack, ServerLevel level, BlockPos blockPos, BlockState blockState) {
        Dye dye = Dye.getDyeFromStack(stack);
        RandomSource randomSource = level.f_46441_;
        if (((DyeColor)blockState.m_61143_(ModStateProperties.COLOR)).equals((Object)dye.color()) || dye.isEmpty()) {
            return;
        }
        level.m_46597_(blockPos, (BlockState)blockState.m_61124_(ModStateProperties.COLOR, (Comparable)dye.color()));
        ItemStack itemStack = Dye.stackFromDye(new Dye(dye.color(), dye.amount() - 1));
        Dye.setDyeToStack(stack, itemStack, itemStack.m_41613_());
        this.particles(randomSource, level, dye, blockPos);
    }

    private void colorColumn(ItemStack stack, ServerLevel level, BlockPos blockPos) {
        BlockPos.MutableBlockPos posUp = blockPos.m_7494_().m_122032_();
        BlockPos.MutableBlockPos posDown = blockPos.m_122032_();
        while (level.m_8055_((BlockPos)posUp).m_60713_((Block)ModBlocks.CAULORFLOWER.get())) {
            this.colorOne(stack, level, (BlockPos)posUp, level.m_8055_((BlockPos)posUp));
            posUp = posUp.m_7494_();
        }
        while (level.m_8055_((BlockPos)posDown).m_60713_((Block)ModBlocks.CAULORFLOWER.get())) {
            this.colorOne(stack, level, (BlockPos)posDown, level.m_8055_((BlockPos)posDown));
            posDown = posDown.m_7495_();
        }
    }

    public boolean m_142305_(ItemStack pStack, ItemStack pOther, Slot pSlot, ClickAction pAction, Player pPlayer, SlotAccess pAccess) {
        if (pAction == ClickAction.SECONDARY && pSlot.m_150651_(pPlayer)) {
            if (pOther.m_41619_()) {
                pAccess.m_142104_(this.remove(pStack));
                this.playRemoveOneSound((Entity)pPlayer);
            } else {
                ItemStack itemStack = this.add(pStack, Dye.getDyeFromStack(pStack), pOther);
                pAccess.m_142104_(itemStack);
                if (itemStack.m_41619_()) {
                    this.playInsertSound((Entity)pPlayer);
                }
            }
            return true;
        }
        return false;
    }

    private void particles(RandomSource randomSource, ServerLevel level, Dye dye, BlockPos blockPos) {
        for (int i = 0; i <= randomSource.m_216332_(5, 10); ++i) {
            level.m_8767_((ParticleOptions)new DustParticleOptions(dye.isEmpty() ? Vec3.m_82501_((int)0xD5D5D5).m_252839_() : Vec3.m_82501_((int)Dye.colorForDye(this, dye.color())).m_252839_(), 1.0f), (double)blockPos.m_123341_() + randomSource.m_188500_(), (double)blockPos.m_123342_() + randomSource.m_188500_(), (double)blockPos.m_123343_() + randomSource.m_188500_(), 1, 0.0, 0.0, 0.0, 0.3);
        }
    }

    @Override
    public void onAddDye(@Nullable ItemStack destinationStack, ItemStack dye, int amount) {
        Dye.setDyeToStack(destinationStack, dye, amount);
    }

    private ItemStack remove(ItemStack pStack) {
        Dye dye = Dye.getDyeFromStack(pStack);
        if (!dye.isEmpty()) {
            Dye.setDyeColorToStack(pStack, DyeColor.WHITE, 0);
            return Dye.stackFromDye(dye);
        }
        return ItemStack.f_41583_;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        Dye dye = Dye.getDyeFromStack(pStack);
        MutableComponent usage = Component.m_264568_((String)"tooltip.dyespria.usage", (String)"Right click with dye to insert \nRight click caulorflower to repaint \nSneak to apply to the whole column \n").m_130940_(ChatFormatting.GOLD);
        if (!dye.isEmpty()) {
            MutableComponent name = Component.m_237113_((String)(dye.amount() + " - " + WordUtils.capitalizeFully((String)dye.color().m_41065_().toLowerCase().replaceAll("[^a-z_]", "").replaceAll("_", " ")))).m_130948_(Style.f_131099_.m_178520_(Dye.colorForDye(this, dye.color())));
            pTooltipComponents.add((Component)usage);
            pTooltipComponents.add((Component)name);
        } else {
            pTooltipComponents.add((Component)usage);
            pTooltipComponents.add((Component)Component.m_264568_((String)"tooltip.dyespria.empty", (String)"Empty").m_130940_(ChatFormatting.GRAY));
        }
    }

    private void playRemoveOneSound(Entity pEntity) {
        pEntity.m_5496_(SoundEvents.f_184216_, 0.8f, 0.8f + pEntity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void playInsertSound(Entity pEntity) {
        pEntity.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + pEntity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    @Override
    public Map<DyeColor, Integer> colorValues() {
        return (Map)Util.m_137469_((Object)Maps.newLinkedHashMap(), dyeColorHexFormatMap -> {
            dyeColorHexFormatMap.put(DyeColor.WHITE, -1);
            dyeColorHexFormatMap.put(DyeColor.LIGHT_GRAY, -6449253);
            dyeColorHexFormatMap.put(DyeColor.GRAY, -12103854);
            dyeColorHexFormatMap.put(DyeColor.BLACK, -14869215);
            dyeColorHexFormatMap.put(DyeColor.BROWN, -8170446);
            dyeColorHexFormatMap.put(DyeColor.RED, -4898002);
            dyeColorHexFormatMap.put(DyeColor.ORANGE, -485835);
            dyeColorHexFormatMap.put(DyeColor.YELLOW, -4525);
            dyeColorHexFormatMap.put(DyeColor.LIME, -8337633);
            dyeColorHexFormatMap.put(DyeColor.GREEN, -10585066);
            dyeColorHexFormatMap.put(DyeColor.CYAN, -16733492);
            dyeColorHexFormatMap.put(DyeColor.LIGHT_BLUE, -9381404);
            dyeColorHexFormatMap.put(DyeColor.BLUE, -12102740);
            dyeColorHexFormatMap.put(DyeColor.PURPLE, -5152830);
            dyeColorHexFormatMap.put(DyeColor.MAGENTA, -2984263);
            dyeColorHexFormatMap.put(DyeColor.PINK, -479036);
        });
    }
}

