/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.config;

import com.legacy.structure_gel.api.config.ConfigBuilder;
import com.legacy.structure_gel.api.data.tags.FilterHolderSet;
import com.legacy.structure_gel.api.registry.registrar.Registrar;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.structure.modifiers.StructureConfigModifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.common.ForgeConfigSpec;

public class StructureConfig {
    private final ResourceKey<Structure> structure;
    private final Optional<ForgeConfigSpec.ConfigValue<List<? extends String>>> biomeFilter;

    private StructureConfig(ResourceKey<Structure> structure, Optional<ForgeConfigSpec.ConfigValue<List<? extends String>>> biomeFilter) {
        this.structure = structure;
        this.biomeFilter = biomeFilter;
    }

    public static Builder builder(ResourceKey<Structure> structure) {
        return new Builder(structure);
    }

    public static Builder builder(Registrar<Structure> structure) {
        return StructureConfig.builder(structure.getKey());
    }

    public ResourceKey<Structure> getStructure() {
        return this.structure;
    }

    public Optional<HolderSet<Biome>> getBiomes(HolderGetter<Biome> biomeRegistry) {
        if (this.biomeFilter.isPresent()) {
            FilterHolderSet.Builder<Biome> builder = FilterHolderSet.builder(Registries.f_256952_);
            List biomeStrings = (List)this.biomeFilter.get().get();
            if (biomeStrings.isEmpty()) {
                return Optional.empty();
            }
            for (String s : biomeStrings) {
                boolean whitelist = true;
                boolean isTag = false;
                if (s.startsWith("#!")) {
                    s = s.replaceFirst("#!", "!#");
                }
                if (s.startsWith("!")) {
                    whitelist = false;
                    s = s.replaceFirst("!", "");
                }
                if (s.startsWith("#")) {
                    isTag = true;
                    s = s.replaceFirst("#", "");
                }
                ResourceLocation rl = new ResourceLocation(s);
                if (isTag) {
                    builder.tags(whitelist, TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)rl));
                    continue;
                }
                builder.values(whitelist, ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)rl));
            }
            return Optional.of(builder.build(biomeRegistry));
        }
        return Optional.empty();
    }

    public static class Builder {
        private final ResourceKey<Structure> structure;
        private boolean hasBiomes = false;
        private List<String> biomeFilterStrings = new ArrayList<String>();

        private Builder(ResourceKey<Structure> structure) {
            this.structure = structure;
        }

        public BiomeConfigBuilder pushBiomes() {
            this.hasBiomes = true;
            return new BiomeConfigBuilder();
        }

        public Builder biomes(String ... biomeStrings) {
            for (String s : biomeStrings) {
                this.biomeFilterStrings.add(s);
            }
            return this;
        }

        public StructureConfig build(ForgeConfigSpec.Builder configBuilder) {
            configBuilder.push(this.structure.m_135782_().m_135815_());
            Optional<Object> biomeConfig = this.hasBiomes ? Optional.of(ConfigBuilder.makeList(configBuilder, this.structure.m_135782_().toString(), "The biomes this structure should generate in. Use # to define a tag. Use ! to define a blacklist. If no values are set, the structure's default biomes will be used.", List.of("minecraft:plains, #minecraft:is_forest, !minecraft:birch_forest, !#minecraft:has_structure/woodland_mansion"), this.biomeFilterStrings, s -> s == null ? false : this.validateBiomeString(s.toString()))) : Optional.empty();
            StructureConfig ret = new StructureConfig(this.structure, biomeConfig);
            if (StructureConfigModifier.CONFIGS.put(this.structure, ret) != null) {
                throw new IllegalStateException("Cannot assign multiple configs to the same structure. Structure: " + this.structure.m_135782_());
            }
            configBuilder.pop();
            return ret;
        }

        private boolean validateBiomeString(String s) {
            String original = s;
            if (original.startsWith("#!")) {
                s = s.replaceFirst("#!", "!#");
            }
            if (s.startsWith("!")) {
                s = s.replaceFirst("!", "");
            }
            if (s.startsWith("#")) {
                s = s.replaceFirst("#", "");
            }
            if (!ResourceLocation.m_135830_((String)s)) {
                return this.logBiomeErr(original, s + " is not a valid resource location. It contains invalid characters.");
            }
            return true;
        }

        private boolean logBiomeErr(String incorrectString, String reason) {
            StructureGelMod.LOGGER.error("The biome config for structure {} contains an invalid string \"{}\". {}", this.structure.m_135782_().toString(), incorrectString, reason);
            return false;
        }

        public class BiomeConfigBuilder {
            public BiomeConfigBuilder biomes(String ... filterStrings) {
                Builder.this.biomes(filterStrings);
                return this;
            }

            @SafeVarargs
            public final BiomeConfigBuilder whitelist(ResourceKey<Biome> ... biomes) {
                for (ResourceKey<Biome> s : biomes) {
                    Builder.this.biomeFilterStrings.add(s.m_135782_().toString());
                }
                return this;
            }

            @SafeVarargs
            public final BiomeConfigBuilder whitelist(Registrar<Biome> ... biomes) {
                for (Registrar<Biome> s : biomes) {
                    Builder.this.biomeFilterStrings.add(s.getKey().m_135782_().toString());
                }
                return this;
            }

            @SafeVarargs
            public final BiomeConfigBuilder whitelist(TagKey<Biome> ... biomes) {
                for (TagKey<Biome> s : biomes) {
                    Builder.this.biomeFilterStrings.add("#" + s.f_203868_().toString());
                }
                return this;
            }

            @SafeVarargs
            public final BiomeConfigBuilder blacklist(ResourceKey<Biome> ... biomes) {
                for (ResourceKey<Biome> s : biomes) {
                    Builder.this.biomeFilterStrings.add("!" + s.m_135782_().toString());
                }
                return this;
            }

            @SafeVarargs
            public final BiomeConfigBuilder blacklist(Registrar<Biome> ... biomes) {
                for (Registrar<Biome> s : biomes) {
                    Builder.this.biomeFilterStrings.add("!" + s.getKey().m_135782_().toString());
                }
                return this;
            }

            @SafeVarargs
            public final BiomeConfigBuilder blacklist(TagKey<Biome> ... biomes) {
                for (TagKey<Biome> s : biomes) {
                    Builder.this.biomeFilterStrings.add("!#" + s.f_203868_().toString());
                }
                return this;
            }

            public Builder popBiomes() {
                return Builder.this;
            }
        }
    }
}

