/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.block;

import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.block_entity.DynamicSpawnerBlockEntity;
import com.legacy.structure_gel.core.registry.SGRegistry;
import com.legacy.structure_gel.core.util.SGText;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class DynamicSpawnerBlock
extends BaseEntityBlock {
    public DynamicSpawnerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new DynamicSpawnerBlockEntity(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof DynamicSpawnerBlockEntity) {
            DynamicSpawnerBlockEntity spawner = (DynamicSpawnerBlockEntity)blockEntity;
            if (player.m_36337_()) {
                if (level.f_46443_) {
                    StructureGelMod.proxy.openDynamicSpawnerScreen(spawner);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return DynamicSpawnerBlock.m_152132_(type, SGRegistry.BlockEntities.DYNAMIC_SPAWNER.get(), (BlockEntityTicker)(level.f_46443_ ? DynamicSpawnerBlockEntity::clientTick : DynamicSpawnerBlockEntity::serverTick));
    }

    public int getExpDrop(BlockState state, LevelReader level, RandomSource rand, BlockPos pos, int fortune, int silktouch) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof DynamicSpawnerBlockEntity) {
            DynamicSpawnerBlockEntity spawner = (DynamicSpawnerBlockEntity)blockEntity;
            DynamicSpawnerBlockEntity.ExpRange range = spawner.getExpRange();
            int min = range.min;
            int max = range.max;
            int r = (max - min) / 2 + 1;
            return min + rand.m_188503_(r) + rand.m_188503_(r);
        }
        return Blocks.f_50085_.getExpDrop(Blocks.f_50085_.m_49966_(), level, rand, pos, fortune, silktouch);
    }

    public RenderShape m_7514_(BlockState p_56794_) {
        return RenderShape.MODEL;
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)SGRegistry.Blocks.DYNAMIC_SPAWNER.get());
    }

    public void m_5871_(ItemStack stack, BlockGetter level, List<Component> lore, TooltipFlag showAdvanced) {
        if (Screen.m_96638_()) {
            lore.add((Component)Component.m_237115_((String)"info.structure_gel.dynamic_spawner_description").m_130940_(ChatFormatting.GRAY));
        } else {
            lore.add(SGText.applyKeybindFilter((Component)Component.m_237115_((String)"info.structure_gel.hold_shift")));
            String beTagKey = "BlockEntityTag";
            CompoundTag tag = stack.m_41783_();
            if (tag != null && tag.m_128425_(beTagKey, 10)) {
                lore.add((Component)SGText.NEW_LINE);
                CompoundTag beTag = tag.m_128469_(beTagKey);
                String typeName = beTag.m_128461_("SpawnerID");
                if (!typeName.isBlank()) {
                    lore.add((Component)SGText.BULLET_POINT.m_6881_().m_130940_(ChatFormatting.GRAY).m_7220_((Component)SGText.TYPE_LABEL.m_6881_().m_130948_(SGText.VALUE_LABEL_STYLE)).m_7220_((Component)Component.m_237113_((String)(": " + typeName))));
                }
                if (beTag.m_128425_("exp_range", 10)) {
                    DynamicSpawnerBlockEntity.ExpRange range = DynamicSpawnerBlockEntity.ExpRange.load(tag.m_128469_("exp_range"));
                    lore.add((Component)SGText.BULLET_POINT.m_6881_().m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237115_((String)"gui.structure_gel.dynamic_spawner.exp_range").m_130948_(SGText.VALUE_LABEL_STYLE)).m_7220_((Component)Component.m_237113_((String)(": " + range.min + " - " + range.max))));
                }
            }
        }
    }
}

