/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.capability.level;

import com.legacy.structure_gel.core.SGConfig;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.capability.level.BuildingToolWorldData;
import com.legacy.structure_gel.core.item.building_tool.ActionHistory;
import com.legacy.structure_gel.core.item.building_tool.CapturedBlocks;
import com.legacy.structure_gel.core.mixin.DimensionDataStorageAccessor;
import com.legacy.structure_gel.core.network.EditClipboardPacket;
import com.legacy.structure_gel.core.network.SGPacketHandler;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class BuildingToolPlayerData
extends SavedData {
    final ServerLevel level;
    final String playerName;
    final ActionHistory actionHistory;
    int clipboardIndex = 0;
    final Int2ObjectLinkedOpenHashMap<CapturedBlocks> clipboard;
    private static final String PLAYER_KEY = "player";
    private static final String ACTION_HISTORY_KEY = "action_history";
    private static final String CLIPBOARD_KEY = "clipboard";
    private static final String CLIPBOARD_INDEX_KEY = "clipboard_index";

    private BuildingToolPlayerData(ServerLevel level, String playerName) {
        this(level, playerName, new ActionHistory(playerName), Collections.emptyMap(), 0);
    }

    private BuildingToolPlayerData(ServerLevel level, String playerName, ActionHistory actionHistory, Map<Integer, CapturedBlocks> clipboard, int clipboardIndex) {
        this.level = level;
        this.playerName = playerName;
        this.actionHistory = actionHistory;
        this.clipboard = new Int2ObjectLinkedOpenHashMap(clipboard);
        this.clipboardIndex = clipboardIndex;
    }

    public static String getID(String playerName) {
        return "structure_gel/building_tool/players/" + playerName;
    }

    public static BuildingToolPlayerData get(ServerLevel level, String playerName) {
        String ID = BuildingToolPlayerData.getID(playerName);
        Map<String, SavedData> cache = ((DimensionDataStorageAccessor)level.m_8895_()).structure_gel$getCache();
        if (cache.containsKey(ID) && cache.get(ID) == null) {
            cache.remove(ID);
        }
        BuildingToolPlayerData ret = (BuildingToolPlayerData)level.m_8895_().m_164861_(tag -> BuildingToolPlayerData.load(level, tag), () -> new BuildingToolPlayerData(level, playerName), ID);
        BuildingToolWorldData.get(level).addPlayer(playerName);
        return ret;
    }

    public Player getPlayer(Level level) {
        for (Player player : level.m_6907_()) {
            if (!player.m_36316_().getName().equals(this.playerName)) continue;
            return player;
        }
        return null;
    }

    public ActionHistory getActionHistory() {
        return this.actionHistory;
    }

    @Nullable
    public CapturedBlocks getCapturedBlocks(int index) {
        CapturedBlocks ret = (CapturedBlocks)this.clipboard.getAndMoveToFirst(index);
        if (ret != null) {
            this.m_77762_();
        }
        return ret;
    }

    public int addToClipboard(CapturedBlocks captured) {
        Player player;
        while (this.clipboard.containsKey(this.clipboardIndex)) {
            ++this.clipboardIndex;
        }
        this.clipboard.putAndMoveToFirst(this.clipboardIndex, (Object)captured);
        int removeKey = -1;
        if (this.clipboard.size() > SGConfig.COMMON.getBuildingToolMaxClipboard()) {
            removeKey = this.clipboard.lastIntKey();
            this.clipboard.removeLast();
        }
        if ((player = this.getPlayer((Level)this.level)) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            SGPacketHandler.sendToClient(new EditClipboardPacket((Level)this.level, this.clipboardIndex, captured, removeKey), player2);
        }
        this.m_77762_();
        return this.clipboardIndex;
    }

    public void addToClipboardDirect(int index, CapturedBlocks captured) {
        this.clipboard.putAndMoveToFirst(index, (Object)captured);
        this.m_77762_();
    }

    public void removeFromClipboard(int index) {
        this.clipboard.remove(index);
        this.m_77762_();
    }

    public void clearClipboard() {
        this.clipboard.clear();
        this.m_77762_();
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        tag.m_128359_(PLAYER_KEY, this.playerName);
        if (!this.actionHistory.isExpired((Level)this.level)) {
            tag.m_128365_(ACTION_HISTORY_KEY, (Tag)ActionHistory.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.actionHistory).getOrThrow(false, s -> StructureGelMod.LOGGER.error("couldn't serialize action history for " + this.playerName + ": " + s, new Object[0])));
        }
        if (!this.clipboard.isEmpty()) {
            CompoundTag clipboardTag = new CompoundTag();
            for (Int2ObjectMap.Entry entry : this.clipboard.int2ObjectEntrySet()) {
                clipboardTag.m_128365_(entry.getKey().toString(), (Tag)((CapturedBlocks)entry.getValue()).toCompressedTag(this.level.m_9598_()));
            }
            tag.m_128365_(CLIPBOARD_KEY, (Tag)clipboardTag);
        }
        tag.m_128405_(CLIPBOARD_INDEX_KEY, this.clipboardIndex);
        return tag;
    }

    private static BuildingToolPlayerData load(ServerLevel level, CompoundTag tag) {
        String playerName = tag.m_128461_(PLAYER_KEY);
        ActionHistory actionHistory = tag.m_128425_(ACTION_HISTORY_KEY, 10) ? (ActionHistory)((Pair)ActionHistory.CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128469_(ACTION_HISTORY_KEY)).getOrThrow(false, s -> StructureGelMod.LOGGER.error("couldn't deserialize action history: " + s, new Object[0]))).getFirst() : new ActionHistory(playerName);
        HashMap<Integer, CapturedBlocks> clipboard = new HashMap<Integer, CapturedBlocks>();
        CompoundTag clipboardTag = tag.m_128469_(CLIPBOARD_KEY);
        for (String key : clipboardTag.m_128431_()) {
            try {
                Integer i = Integer.parseInt(key);
                clipboard.put(i, CapturedBlocks.fromCompressedTag(level.m_9598_(), clipboardTag.m_128469_(key)));
            }
            catch (NumberFormatException e) {
                StructureGelMod.LOGGER.error("Could not read clipboard data for {} with index {}", playerName, key, e);
            }
        }
        return new BuildingToolPlayerData(level, playerName, actionHistory, clipboard, tag.m_128451_(CLIPBOARD_INDEX_KEY));
    }

    public boolean m_77764_() {
        return super.m_77764_() || this.actionHistory.isDirty();
    }

    public void m_77757_(File file) {
        file.getParentFile().mkdirs();
        super.m_77757_(file);
        this.actionHistory.setDirty(false);
        if (this.actionHistory.isExpired((Level)this.level)) {
            this.level.m_8895_().m_164855_(BuildingToolPlayerData.getID(this.playerName), null);
        }
    }

    public static class BuildingToolClientData
    extends BuildingToolPlayerData {
        public BuildingToolClientData(String playerName) {
            super(null, playerName);
        }

        @Override
        public CompoundTag m_7176_(CompoundTag tag) {
            return tag;
        }

        @Override
        public void m_77757_(File file) {
        }
    }
}

