/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.item.building_tool.modes;

import com.legacy.structure_gel.api.structure.base.IModifyState;
import com.legacy.structure_gel.core.item.building_tool.ActionHistory;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolItem;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolMode;
import com.legacy.structure_gel.core.item.building_tool.ToolModeProperty;
import com.legacy.structure_gel.core.util.SGText;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Style;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class ShapeTool
extends BuildingToolMode {
    public ShapeTool(String name, int modelIndex) {
        super(name, modelIndex);
    }

    @Override
    public void onLeftClick(Level level, Player player, BlockPos clickedPos, ItemStack stack, Direction clickedFace) {
        if (level.f_46443_) {
            return;
        }
        WeightedRandomList<WeightedEntry.Wrapper<BlockState>> pallete = BuildingToolItem.getPallete(stack);
        if (!pallete.m_146337_()) {
            double integrity = BuildingToolItem.getProperty(stack, ToolModeProperty.INTEGRITY);
            int radius = BuildingToolItem.getProperty(stack, ToolModeProperty.RADIUS);
            ToolModeProperty.Shape shape = BuildingToolItem.getProperty(stack, ToolModeProperty.SHAPE);
            ToolModeProperty.Replace replace = BuildingToolItem.getProperty(stack, ToolModeProperty.REPLACE);
            BlockState clickedState = level.m_8055_(clickedPos);
            ActionHistory.ActionBuilder action = ActionHistory.newAction();
            RandomSource rand = level.m_213780_();
            int total = this.forPosesWithin((Vec3i)clickedPos.m_7918_(-radius, -radius, -radius), (Vec3i)clickedPos.m_7918_(radius, radius, radius), pos -> {
                Optional opState;
                if ((double)rand.m_188501_() < integrity && shape.isInside((Vec3i)clickedPos.m_7918_(-pos.m_123341_(), -pos.m_123342_(), -pos.m_123343_()), radius) && replace.shouldReplace(level, clickedState, (BlockPos)pos) && (opState = pallete.m_216829_(rand)).isPresent()) {
                    return this.setBlock(level, (BlockPos)pos, (BlockState oldState) -> replace == ToolModeProperty.Replace.CLICKED_BLOCK ? IModifyState.mergeStates((BlockState)((WeightedEntry.Wrapper)opState.get()).m_146310_(), oldState) : (BlockState)((WeightedEntry.Wrapper)opState.get()).m_146310_(), action);
                }
                return false;
            });
            ActionHistory.get(player).add(level, action);
            ShapeTool.sendPlaceMessage(player, replace, total, pallete);
        } else {
            BuildingToolMode.sendMessage(player, "info.structure_gel.building_tool.message.missing_state", Style.f_131099_.m_131140_(ChatFormatting.RED), new Object[0]);
        }
    }

    @Override
    public int getReachDistance(ItemStack stack) {
        int radius = BuildingToolItem.getProperty(stack, ToolModeProperty.RADIUS);
        return 2 + radius;
    }

    @Override
    public Object[] getDescArgs() {
        Options options = Minecraft.m_91087_().f_91066_;
        String middleClick = SGText.keybindString(options.f_92097_);
        String leftClick = SGText.keybindString(options.f_92096_);
        return new Object[]{middleClick, leftClick};
    }

    @Override
    public void addProperties(List<ToolModeProperty<?>> properties) {
        super.addProperties(properties);
        properties.add(ToolModeProperty.INTEGRITY);
        properties.add(ToolModeProperty.RADIUS);
        properties.add(ToolModeProperty.SHAPE);
        properties.add(ToolModeProperty.REPLACE);
    }

    @Override
    public boolean hasBlockPalette() {
        return true;
    }
}

