/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class BlockBigLeavesArea
extends LeavesBlock {
    public int decayDistance;
    public int flammability;
    public int fireSpread;
    public boolean isFlammable;
    public static final IntegerProperty DISTANCE_BIG = IntegerProperty.m_61631_((String)"distance_big", (int)1, (int)20);

    public BlockBigLeavesArea(BlockBehaviour.Properties pProperties, int decayDistance, int flammability, int fireSpread, boolean isFlammable) {
        super(pProperties);
        this.decayDistance = decayDistance;
        this.flammability = flammability;
        this.fireSpread = fireSpread;
        this.isFlammable = isFlammable;
    }

    public boolean isFlammable(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return this.isFlammable;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return this.flammability;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return this.fireSpread;
    }

    protected boolean m_221385_(BlockState state) {
        return (Boolean)state.m_61143_((Property)f_54419_) == false && (Integer)state.m_61143_((Property)DISTANCE_BIG) >= this.decayDistance;
    }

    public boolean m_6724_(BlockState pState) {
        return (Integer)pState.m_61143_((Property)DISTANCE_BIG) == this.decayDistance && (Boolean)pState.m_61143_((Property)f_54419_) == false;
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        int i;
        if (((Boolean)pState.m_61143_((Property)f_221367_)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        if ((i = this.getDistanceAt(pFacingState) + 1) != 1 || (Integer)pState.m_61143_((Property)DISTANCE_BIG) != i) {
            pLevel.m_186460_(pCurrentPos, (Block)this, 1);
        }
        return pState;
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        pLevel.m_7731_(pPos, this.updateDistance(pState, (LevelAccessor)pLevel, pPos), 3);
    }

    private BlockState updateDistance(BlockState pState, LevelAccessor pLevel, BlockPos pPos) {
        int i = 7;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            blockpos$mutableblockpos.m_122159_((Vec3i)pPos, direction);
            i = Math.min(i, this.getDistanceAt(pLevel.m_8055_((BlockPos)blockpos$mutableblockpos)) + 1);
            if (i == 1) break;
        }
        return (BlockState)pState.m_61124_((Property)DISTANCE_BIG, (Comparable)Integer.valueOf(i));
    }

    private int getDistanceAt(BlockState pNeighbor) {
        if (pNeighbor.m_204336_(BlockTags.f_13106_)) {
            return 0;
        }
        return pNeighbor.m_60734_() instanceof BlockBigLeavesArea ? (Integer)pNeighbor.m_61143_((Property)DISTANCE_BIG) : this.decayDistance;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{DISTANCE_BIG});
    }
}

