/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.entity;

import com.peeko32213.unusualprehistory.common.entity.msc.util.HitboxHelper;
import com.peeko32213.unusualprehistory.core.registry.UPSounds;
import java.util.EnumSet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class EntitySludge
extends Monster
implements GeoAnimatable {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Integer> ANIMATION_STATE = SynchedEntityData.m_135353_(EntitySludge.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> COMBAT_STATE = SynchedEntityData.m_135353_(EntitySludge.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ENTITY_STATE = SynchedEntityData.m_135353_(EntitySludge.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final RawAnimation SLUDGE_CLAP = RawAnimation.begin().thenLoop("animation.sludge.clap");
    private static final RawAnimation SLUDGE_WALK = RawAnimation.begin().thenLoop("animation.sludge.walk");
    private static final RawAnimation SLUDGE_IDLE = RawAnimation.begin().thenLoop("animation.sludge.idle");

    public EntitySludge(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22281_, 15.0).m_22268_(Attributes.f_22279_, 0.12).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22285_, 10.0).m_22268_(Attributes.f_22278_, 20.5);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(8, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SludgeMeleeAttackGoal(this, 1.0, true));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)UPSounds.SLUDGE_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)UPSounds.SLUDGE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)UPSounds.SLUDGE_DEATH.get();
    }

    public int getAnimationState() {
        return (Integer)this.f_19804_.m_135370_(ANIMATION_STATE);
    }

    public void setAnimationState(int anim) {
        this.f_19804_.m_135381_(ANIMATION_STATE, (Object)anim);
    }

    public int getCombatState() {
        return (Integer)this.f_19804_.m_135370_(COMBAT_STATE);
    }

    public void setCombatState(int anim) {
        this.f_19804_.m_135381_(COMBAT_STATE, (Object)anim);
    }

    public int getEntityState() {
        return (Integer)this.f_19804_.m_135370_(ENTITY_STATE);
    }

    public void setEntityState(int anim) {
        this.f_19804_.m_135381_(ENTITY_STATE, (Object)anim);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIMATION_STATE, (Object)0);
        this.f_19804_.m_135372_(COMBAT_STATE, (Object)0);
        this.f_19804_.m_135372_(ENTITY_STATE, (Object)0);
    }

    protected <E extends EntitySludge> PlayState Controller(AnimationState<E> event) {
        int animState = this.getAnimationState();
        switch (animState) {
            case 21: {
                event.getController().setAnimationSpeed((double)0.8f);
                event.setAndContinue(SLUDGE_CLAP);
                return PlayState.CONTINUE;
            }
        }
        if (!(event.getLimbSwingAmount() > -0.06f) || !(event.getLimbSwingAmount() < 0.06f)) {
            event.setAndContinue(SLUDGE_WALK);
            return PlayState.CONTINUE;
        }
        event.getController().setAnimationSpeed(1.0);
        event.setAndContinue(SLUDGE_IDLE);
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Normal", 5, this::Controller)});
    }

    public double getTick(Object o) {
        return this.f_19797_;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    static class SludgeMeleeAttackGoal
    extends Goal {
        protected final EntitySludge mob;
        private final double speedModifier;
        private final boolean followingTargetEvenIfNotSeen;
        private Path path;
        private double pathedTargetX;
        private double pathedTargetY;
        private double pathedTargetZ;
        private int ticksUntilNextPathRecalculation;
        private int ticksUntilNextAttack;
        private long lastCanUseCheck;
        private int animTime = 0;
        Vec3 rightOffset = new Vec3(0.0, 0.0, 0.5);

        public SludgeMeleeAttackGoal(EntitySludge p_i1636_1_, double p_i1636_2_, boolean p_i1636_4_) {
            this.mob = p_i1636_1_;
            this.speedModifier = p_i1636_2_;
            this.followingTargetEvenIfNotSeen = p_i1636_4_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            long i = this.mob.m_9236_().m_46467_();
            if (i - this.lastCanUseCheck < 20L) {
                return false;
            }
            this.lastCanUseCheck = i;
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
            if (this.path != null) {
                return true;
            }
            return this.getAttackReachSqr(livingentity) >= this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
        }

        public boolean m_8045_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (!this.followingTargetEvenIfNotSeen) {
                return !this.mob.m_21573_().m_26571_();
            }
            if (!this.mob.m_21444_(livingentity.m_20183_())) {
                return false;
            }
            return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
        }

        public void m_8056_() {
            this.mob.m_21573_().m_26536_(this.path, this.speedModifier);
            this.ticksUntilNextPathRecalculation = 0;
            this.ticksUntilNextAttack = 0;
            this.animTime = 0;
            this.mob.setAnimationState(0);
        }

        public void m_8041_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (!EntitySelector.f_20406_.test(livingentity)) {
                this.mob.setAnimationState(0);
                this.mob.m_6710_(null);
            }
            this.mob.setAnimationState(0);
        }

        public void m_8037_() {
            LivingEntity target = this.mob.m_5448_();
            double distance = this.mob.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            double reach = this.getAttackReachSqr(target);
            int animState = this.mob.getAnimationState();
            switch (animState) {
                case 21: {
                    this.tickClapAttack();
                    break;
                }
                default: {
                    this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
                    this.ticksUntilNextAttack = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
                    this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                    this.doMovement(target, distance);
                    this.checkForCloseRangeAttack(distance, reach);
                }
            }
        }

        protected void doMovement(LivingEntity livingentity, Double d0) {
            this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
            if ((this.followingTargetEvenIfNotSeen || this.mob.m_21574_().m_148306_((Entity)livingentity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.m_217043_().m_188501_() < 0.05f)) {
                this.pathedTargetX = livingentity.m_20185_();
                this.pathedTargetY = livingentity.m_20186_();
                this.pathedTargetZ = livingentity.m_20189_();
                this.ticksUntilNextPathRecalculation = 4 + this.mob.m_217043_().m_188503_(7);
                if (d0 > 1024.0) {
                    this.ticksUntilNextPathRecalculation += 10;
                } else if (d0 > 256.0) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
                if (!this.mob.m_21573_().m_5624_((Entity)livingentity, this.speedModifier)) {
                    this.ticksUntilNextPathRecalculation += 15;
                }
            }
        }

        protected void checkForCloseRangeAttack(double distance, double reach) {
            if (distance <= reach && this.ticksUntilNextAttack <= 0) {
                int r = this.mob.m_217043_().m_188503_(2048);
                if (r <= 600) {
                    this.mob.setAnimationState(21);
                } else if (r > 600 && r <= 800) {
                    this.mob.setAnimationState(22);
                } else if (r > 800 && r <= 1400) {
                    this.mob.setAnimationState(23);
                } else {
                    this.mob.setAnimationState(24);
                }
            }
        }

        protected boolean getRangeCheck() {
            return this.mob.m_20275_(this.mob.m_5448_().m_20185_(), this.mob.m_5448_().m_20186_(), this.mob.m_5448_().m_20189_()) <= (double)1.8f * this.getAttackReachSqr(this.mob.m_5448_());
        }

        protected void tickClapAttack() {
            ++this.animTime;
            if (this.animTime <= 3) {
                this.mob.m_21391_((Entity)this.mob.m_5448_(), 100000.0f, 100000.0f);
                this.mob.f_20883_ = this.mob.f_20885_;
            }
            if (this.animTime == 6) {
                this.preformClapAttack();
            }
            if (this.animTime >= 11) {
                this.animTime = 0;
                this.mob.setAnimationState(0);
                this.resetAttackCooldown();
                this.ticksUntilNextPathRecalculation = 0;
            }
        }

        protected void preformClapAttack() {
            Vec3 pos = this.mob.m_20182_();
            this.mob.m_5496_((SoundEvent)UPSounds.SLUDGE_SLAP.get(), 1.0f, 1.0f);
            HitboxHelper.PivotedPolyHitCheck((LivingEntity)this.mob, this.rightOffset, 2.0, 2.0, 2.0, (ServerLevel)this.mob.m_9236_(), 15.0f, this.mob.m_269291_().m_269333_((LivingEntity)this.mob), 0.5f, false);
        }

        protected void resetAttackCooldown() {
            this.ticksUntilNextAttack = 0;
        }

        protected boolean isTimeToAttack() {
            return this.ticksUntilNextAttack <= 0;
        }

        protected int getTicksUntilNextAttack() {
            return this.ticksUntilNextAttack;
        }

        protected int getAttackInterval() {
            return 5;
        }

        protected double getAttackReachSqr(LivingEntity p_179512_1_) {
            return this.mob.m_20205_() * 2.5f * this.mob.m_20205_() * 1.8f + p_179512_1_.m_20205_();
        }
    }
}

