/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.world.feature;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.peeko32213.unusualprehistory.core.registry.UPBlocks;
import com.peeko32213.unusualprehistory.core.registry.util.FastNoiseLite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.slf4j.Logger;

public class PetrifiedTreeFeature
extends Feature<NoneFeatureConfiguration> {
    private static final Logger LOGGER = LogUtils.getLogger();

    public PetrifiedTreeFeature(Codec<NoneFeatureConfiguration> config) {
        super(config);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        boolean placeFeature;
        WorldGenLevel worldgenlevel = context.m_159774_();
        BlockPos blockpos = context.m_159777_();
        RandomSource random = context.m_225041_();
        FastNoiseLite noise = PetrifiedTreeFeature.createNoise(worldgenlevel.m_7328_() + random.m_188505_(), random.m_188501_());
        int randomNr = random.m_216339_(0, 50);
        boolean bl = placeFeature = randomNr < 5;
        if (!placeFeature) {
            return false;
        }
        double middleBlockZ = worldgenlevel.m_6325_(blockpos.m_123341_() >> 4, blockpos.m_123343_() >> 4).m_7697_().m_151393_();
        double middleBlockX = worldgenlevel.m_6325_(blockpos.m_123341_() >> 4, blockpos.m_123343_() >> 4).m_7697_().m_151390_();
        double cornerBlockZ = worldgenlevel.m_6325_(blockpos.m_123341_() >> 4, blockpos.m_123343_() >> 4).m_7697_().m_45605_();
        double cornerBlockX = worldgenlevel.m_6325_(blockpos.m_123341_() >> 4, blockpos.m_123343_() >> 4).m_7697_().m_45604_();
        BlockPos blockPosMid = BlockPos.m_274561_((double)middleBlockX, (double)worldgenlevel.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, (int)middleBlockX, (int)middleBlockZ), (double)middleBlockZ);
        BlockPos blockPosCorner = BlockPos.m_274561_((double)cornerBlockX, (double)worldgenlevel.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, (int)cornerBlockX, (int)cornerBlockZ), (double)cornerBlockZ);
        int radius = random.m_216339_(5, 25);
        PetrifiedTreeFeature.changeTerrain(worldgenlevel, random, blockPosMid, noise, radius);
        PetrifiedTreeFeature.addBushes(worldgenlevel, random, blockPosMid, noise, radius);
        PetrifiedTreeFeature.createSphere(worldgenlevel, random, blockPosMid, noise);
        PetrifiedTreeFeature.populateWithTrees(worldgenlevel, random, blockPosMid, noise, radius);
        return true;
    }

    public static void createSphere(WorldGenLevel worldgenlevel, RandomSource rand, BlockPos origin, FastNoiseLite noise) {
        int height;
        int radius = height = rand.m_216339_(2, 4);
        BlockState block = Blocks.f_50069_.m_49966_();
        BlockState block2 = ((Block)UPBlocks.STONE_FOSSIL.get()).m_49966_();
        origin = origin.m_7918_(0, -radius / 2 - 1, 0);
        boolean changeBlock = rand.m_188499_();
        if (changeBlock) {
            block2 = rand.m_188499_() ? ((Block)UPBlocks.STONE_AMBER_FOSSIL.get()).m_49966_() : ((Block)UPBlocks.PLANT_FOSSIL.get()).m_49966_();
        }
        for (int x = -radius; x < radius; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = -radius; z < radius; ++z) {
                    BlockPos pos = origin.m_7918_(x, y, z);
                    BlockPos pos2 = origin.m_7918_(x, -y, z);
                    double distance = PetrifiedTreeFeature.distance(x, y, z, radius, height, radius);
                    float f = noise.GetNoise(x, y, z);
                    if (!(distance < 1.0)) continue;
                    if ((double)f < 0.5) {
                        worldgenlevel.m_7731_(pos, block, 3);
                        worldgenlevel.m_7731_(pos2, block, 3);
                        continue;
                    }
                    if (!((double)f > 0.6) || !((double)f < 0.8)) continue;
                    worldgenlevel.m_7731_(pos, block2, 3);
                    worldgenlevel.m_7731_(pos2, block2, 3);
                }
            }
        }
    }

    public static void populateWithTrees(WorldGenLevel worldgenlevel, RandomSource rand, BlockPos origin, FastNoiseLite noise, int radius) {
        BlockState block = ((RotatedPillarBlock)UPBlocks.PETRIFIED_WOOD_LOG.get()).m_49966_();
        for (int x = -radius; x < radius; ++x) {
            for (int z = -radius; z < radius; ++z) {
                BlockPos pos = origin.m_7918_(x, 0, z);
                double yHeight = worldgenlevel.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, pos.m_123341_(), pos.m_123343_()) - 1;
                BlockPos pos2 = BlockPos.m_274561_((double)pos.m_123341_(), (double)yHeight, (double)pos.m_123343_());
                double distance = PetrifiedTreeFeature.distance(x, 0.0, z, radius, 1.0, radius);
                float f = noise.GetNoise(x, (float)yHeight, z);
                if (!(distance < 1.0) || !((double)f > 0.6) || !((double)f < 0.8)) continue;
                int randomTreeHeight = rand.m_216339_(1, 5);
                for (int treeHeight = 1; treeHeight < randomTreeHeight && !PetrifiedTreeFeature.hasPetrifiedWoodNextToIt(worldgenlevel, pos2, rand); ++treeHeight) {
                    worldgenlevel.m_7731_(pos2.m_7918_(0, treeHeight, 0), block, 3);
                }
            }
        }
    }

    public static void changeTerrain(WorldGenLevel worldgenlevel, RandomSource rand, BlockPos origin, FastNoiseLite noise, int radius) {
        BlockState block = Blocks.f_49992_.m_49966_();
        BlockState block2 = Blocks.f_50493_.m_49966_();
        BlockState block3 = Blocks.f_50546_.m_49966_();
        for (int x = -radius; x < radius; ++x) {
            for (int z = -radius; z < radius; ++z) {
                boolean isCorrectBlock;
                BlockPos pos = origin.m_7918_(x, 0, z);
                double yHeight = worldgenlevel.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, pos.m_123341_(), pos.m_123343_()) - 1;
                BlockPos pos2 = BlockPos.m_274561_((double)pos.m_123341_(), (double)yHeight, (double)pos.m_123343_());
                if (worldgenlevel.m_204166_(pos2).m_203656_(BiomeTags.f_207607_)) {
                    block = Blocks.f_49993_.m_49966_();
                }
                double distance = PetrifiedTreeFeature.distance(x, 0.0, z, radius, 1.0, radius);
                float f = noise.GetNoise(x, (float)yHeight, z);
                if (!(distance < 1.0)) continue;
                boolean bl = isCorrectBlock = worldgenlevel.m_8055_(pos2).m_204336_(BlockTags.f_144274_) || worldgenlevel.m_8055_(pos2).m_204336_(BlockTags.f_13029_);
                if (f < 0.0f && isCorrectBlock) {
                    worldgenlevel.m_7731_(pos2, block, 3);
                    continue;
                }
                if ((double)f < 0.4 && f > 0.0f && isCorrectBlock) {
                    worldgenlevel.m_7731_(pos2, block2, 3);
                    continue;
                }
                if (!isCorrectBlock) continue;
                worldgenlevel.m_7731_(pos2, block3, 3);
            }
        }
    }

    public static void addBushes(WorldGenLevel worldgenlevel, RandomSource rand, BlockPos origin, FastNoiseLite noise, int radius) {
        BlockState block = ((Block)UPBlocks.PETRIFIED_BUSH.get()).m_49966_();
        for (int x = -radius; x < radius; ++x) {
            for (int z = -radius; z < radius; ++z) {
                BlockPos pos = origin.m_7918_(x, 0, z);
                double yHeight = worldgenlevel.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, pos.m_123341_(), pos.m_123343_());
                BlockPos pos2 = BlockPos.m_274561_((double)pos.m_123341_(), (double)yHeight, (double)pos.m_123343_());
                double distance = PetrifiedTreeFeature.distance(x, 0.0, z, radius, 1.0, radius);
                float f = noise.GetNoise(x, (float)yHeight, z);
                if (!(distance < 1.0)) continue;
                boolean isCorrectBlock = worldgenlevel.m_8055_(pos2).m_60713_(Blocks.f_50016_);
                if (!(f > 0.0f) || !((double)f < 0.05) || !isCorrectBlock) continue;
                worldgenlevel.m_7731_(pos2, block, 3);
            }
        }
    }

    public static double distance(double x, double y, double z, double xRadius, double yRadius, double zRadius) {
        return Mth.m_144952_((double)(x / xRadius)) + Mth.m_144952_((double)(y / yRadius)) + Mth.m_144952_((double)(z / zRadius));
    }

    public static boolean hasPetrifiedWoodNextToIt(WorldGenLevel worldGenLevel, BlockPos pos, RandomSource randomSource) {
        boolean checkForWood;
        int randomNr = randomSource.m_216339_(0, 100);
        boolean bl = checkForWood = randomNr > 10;
        if (!checkForWood) {
            return false;
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockState blockstate1 = worldGenLevel.m_8055_(pos.m_121945_(direction));
            if (!blockstate1.m_60713_((Block)UPBlocks.PETRIFIED_WOOD_LOG.get())) continue;
            return true;
        }
        return false;
    }

    private static FastNoiseLite createNoise(long seed, float frequency) {
        FastNoiseLite noise = new FastNoiseLite((int)seed);
        noise.SetNoiseType(FastNoiseLite.NoiseType.OpenSimplex2S);
        noise.SetFrequency(frequency);
        return noise;
    }
}

