/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.datagen;

import com.google.common.collect.Sets;
import com.peeko32213.unusualprehistory.datagen.AdvancementProvider;
import com.peeko32213.unusualprehistory.datagen.BiomeTagsProvider;
import com.peeko32213.unusualprehistory.datagen.BlockTagsGenerator;
import com.peeko32213.unusualprehistory.datagen.BlockstateGenerator;
import com.peeko32213.unusualprehistory.datagen.EntityTagsGenerator;
import com.peeko32213.unusualprehistory.datagen.InstrumentTagsGenerator;
import com.peeko32213.unusualprehistory.datagen.ItemModelGenerator;
import com.peeko32213.unusualprehistory.datagen.ItemTagsGenerator;
import com.peeko32213.unusualprehistory.datagen.LanguageGenerator;
import com.peeko32213.unusualprehistory.datagen.LootGenerator;
import com.peeko32213.unusualprehistory.datagen.RecipeGenerator;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="unusualprehistory", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent evt) {
        if (evt.includeServer()) {
            DataGenerators.registerServerProviders(evt.getGenerator(), evt);
        }
    }

    private static void registerServerProviders(DataGenerator generator, GatherDataEvent evt) {
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper helper = evt.getExistingFileHelper();
        HashSet set = Sets.newHashSet();
        Consumer<BlockStateGenerator> consumer = set::add;
        CompletableFuture provider = evt.getLookupProvider();
        CompletableFuture lookupProvider = evt.getLookupProvider();
        generator.addProvider(true, (DataProvider)new EntityTagsGenerator(packOutput, lookupProvider, helper));
        generator.addProvider(true, (DataProvider)new RecipeGenerator(packOutput));
        generator.addProvider(true, (DataProvider)new BlockstateGenerator(packOutput, helper));
        generator.addProvider(true, (DataProvider)new ItemModelGenerator(packOutput, helper));
        generator.addProvider(true, (DataProvider)new LanguageGenerator(packOutput));
        generator.addProvider(evt.includeServer(), (DataProvider)LootGenerator.create(packOutput));
        generator.addProvider(true, (DataProvider)new BiomeTagsProvider(packOutput, lookupProvider, helper));
        generator.addProvider(true, (DataProvider)new InstrumentTagsGenerator(packOutput, lookupProvider, helper));
        generator.addProvider(true, (DataProvider)new AdvancementProvider(packOutput, provider, helper));
        BlockTagsGenerator blockTagGenerator = (BlockTagsGenerator)generator.addProvider(evt.includeServer(), (DataProvider)new BlockTagsGenerator(packOutput, lookupProvider, helper));
        generator.addProvider(evt.includeServer(), (DataProvider)new ItemTagsGenerator(packOutput, lookupProvider, blockTagGenerator.m_274426_(), helper));
    }
}

