/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.compat.jei.recipe;

import com.google.gson.JsonObject;
import com.li64.tide.Tide;
import com.li64.tide.data.TideTags;
import com.li64.tide.data.rods.CustomRodManager;
import com.li64.tide.data.rods.ModifierType;
import java.util.Random;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public class RodUpgradingRecipe
implements Recipe<Container> {
    private final ItemStack input;
    private final ItemStack output;
    private final ResourceLocation id;

    public RodUpgradingRecipe(ItemStack input, ItemStack output, ResourceLocation id) {
        this.input = input;
        this.output = output;
        this.id = id;
    }

    public boolean m_5818_(Container input, Level level) {
        return !level.f_46443_;
    }

    public ItemStack m_5874_(Container input, RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        ItemStack newRod = this.output.m_41777_();
        CustomRodManager.setModifier(newRod, ModifierType.BOBBER, new Random().nextInt(0, 16));
        CustomRodManager.setModifier(newRod, ModifierType.HOOK, new Random().nextInt(0, 3));
        CustomRodManager.setModifier(newRod, ModifierType.LINE, new Random().nextInt(0, 4));
        return newRod;
    }

    public RecipeSerializer<RodUpgradingRecipe> m_7707_() {
        return Serializer.INSTANCE;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeType<RodUpgradingRecipe> m_6671_() {
        return Type.INSTANCE;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public Ingredient getModifier(int modifier) {
        return switch (modifier) {
            case 0 -> Ingredient.m_204132_(TideTags.Items.LINES);
            case 1 -> Ingredient.m_204132_(TideTags.Items.BOBBERS);
            default -> Ingredient.m_204132_(TideTags.Items.HOOKS);
        };
    }

    public static class Serializer
    implements RecipeSerializer<RodUpgradingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = Tide.resource("rod_upgrading");

        public RodUpgradingRecipe fromJson(ResourceLocation recipeId, JsonObject serializedRecipe) {
            ItemStack input = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)serializedRecipe, (String)"input"));
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)serializedRecipe, (String)"output"));
            return new RodUpgradingRecipe(input, output, recipeId);
        }

        public RodUpgradingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ItemStack input = buffer.m_130267_();
            ItemStack output = buffer.m_130267_();
            return new RodUpgradingRecipe(input, output, recipeId);
        }

        public void toNetwork(FriendlyByteBuf buffer, RodUpgradingRecipe recipe) {
            buffer.m_130055_(recipe.input);
            buffer.m_130055_(recipe.m_8043_(null));
        }
    }

    public static class Type
    implements RecipeType<RodUpgradingRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "rod_upgrading";
    }
}

