/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.journal.config;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.li64.tide.Tide;
import com.li64.tide.data.journal.JournalLayout;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class JournalProfileCustomData
extends SimpleJsonResourceReloadListener {
    public static final String DATA_PATH = "journal/profiles";
    private static final Gson GSON = new Gson();

    public JournalProfileCustomData() {
        super(GSON, DATA_PATH);
    }

    @NotNull
    public String m_7812_() {
        return "Tide Journal Profile Data Loader";
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> map, @NotNull ResourceManager manager, @NotNull ProfilerFiller profiler) {
        ArrayList output = new ArrayList();
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            ResourceLocation entryKey = entry.getKey();
            try {
                JournalLayout.Profile.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)entry.getValue()).result().ifPresentOrElse(output::add, () -> Tide.LOG.warn("Did not load invalid profile entry {}", (Object)entryKey));
            }
            catch (JsonParseException | IllegalArgumentException parseException) {
                Tide.LOG.error("Parsing error loading custom journal profile {}", (Object)entryKey, (Object)parseException);
            }
        }
        ImmutableList profiles = ImmutableList.copyOf(output);
        Tide.LOG.info("Loaded {} custom journal profiles", (Object)profiles.size());
        Tide.JOURNAL.addProfileConfigs((List<JournalLayout.Profile>)profiles);
    }
}

