/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.journal.config;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.li64.tide.Tide;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class JournalRemovalCustomData
extends SimpleJsonResourceReloadListener {
    public static final String DATA_PATH = "journal/removals";
    private static final Gson GSON = new Gson();

    public JournalRemovalCustomData() {
        super(GSON, DATA_PATH);
    }

    @NotNull
    public String m_7812_() {
        return "Tide Journal Profile Data Loader";
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> map, @NotNull ResourceManager manager, @NotNull ProfilerFiller profiler) {
        ArrayList output = new ArrayList();
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            ResourceLocation entryKey = entry.getKey();
            try {
                JournalRemoval.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)entry.getValue()).result().ifPresentOrElse(output::add, () -> Tide.LOG.warn("Did not load invalid removal entry {}", (Object)entryKey));
            }
            catch (JsonParseException | IllegalArgumentException parseException) {
                Tide.LOG.error("Parsing error loading journal removal {}", (Object)entryKey, (Object)parseException);
            }
        }
        ImmutableList removals = ImmutableList.copyOf(output);
        Tide.LOG.info("Loaded {} journal removals", (Object)removals.size());
        Tide.JOURNAL.removeProfileConfigs((List<JournalRemoval>)removals);
    }

    public record JournalRemoval(String item) {
        public static final Codec<JournalRemoval> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("item").forGetter(JournalRemoval::item)).apply((Applicative)instance, JournalRemoval::new));
    }
}

