/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.rods;

import com.li64.tide.data.rods.BobberModifier;
import com.li64.tide.data.rods.HookModifier;
import com.li64.tide.data.rods.LineModifier;
import com.li64.tide.data.rods.ModifierType;
import java.util.Arrays;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class CustomRodManager {
    private static final BobberModifier DEFAULT_BOBBER = BobberModifier.RED;
    private static final HookModifier DEFAULT_HOOK = HookModifier.NORMAL;
    private static final LineModifier DEFAULT_LINE = LineModifier.NORMAL;

    private static void createModifierTag(ItemStack stack) {
        CompoundTag modifierTag = new CompoundTag();
        modifierTag.m_128405_("bobber", DEFAULT_BOBBER.ordinal());
        modifierTag.m_128405_("hook", DEFAULT_HOOK.ordinal());
        modifierTag.m_128405_("line", DEFAULT_LINE.ordinal());
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        stack.m_41783_().m_128365_("modifier", (Tag)modifierTag);
    }

    private static void updateModifiers(ItemStack stack) {
        if (!CustomRodManager.hasModifierTag(stack)) {
            CustomRodManager.createModifierTag(stack);
        }
    }

    public static void setBobber(ItemStack stack, Item bobber) {
        CustomRodManager.setModifier(stack, ModifierType.BOBBER, Arrays.stream(BobberModifier.values()).filter(modifier -> bobber == modifier.getItem()).findFirst().orElse(DEFAULT_BOBBER).ordinal());
    }

    public static void setHook(ItemStack stack, Item hook) {
        CustomRodManager.setModifier(stack, ModifierType.HOOK, Arrays.stream(HookModifier.values()).filter(modifier -> hook == modifier.getItem()).findFirst().orElse(DEFAULT_HOOK).ordinal());
    }

    public static void setLine(ItemStack stack, Item line) {
        CustomRodManager.setModifier(stack, ModifierType.LINE, Arrays.stream(LineModifier.values()).filter(modifier -> line == modifier.getItem()).findFirst().orElse(DEFAULT_LINE).ordinal());
    }

    public static void setModifier(ItemStack stack, ModifierType modifier, int value) {
        CustomRodManager.updateModifiers(stack);
        CustomRodManager.getModifierTag(stack).m_128405_(modifier.getID(), value);
    }

    public static boolean hasModifierTag(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_("modifier");
    }

    public static CompoundTag getModifierTag(ItemStack stack) {
        CustomRodManager.updateModifiers(stack);
        return (CompoundTag)stack.m_41783_().m_128423_("modifier");
    }

    public static BobberModifier getBobber(ItemStack stack) {
        CustomRodManager.updateModifiers(stack);
        return BobberModifier.values()[CustomRodManager.getModifierTag(stack).m_128451_("bobber")];
    }

    public static HookModifier getHook(ItemStack stack) {
        CustomRodManager.updateModifiers(stack);
        return HookModifier.values()[CustomRodManager.getModifierTag(stack).m_128451_("hook")];
    }

    public static LineModifier getLine(ItemStack stack) {
        CustomRodManager.updateModifiers(stack);
        return LineModifier.values()[CustomRodManager.getModifierTag(stack).m_128451_("line")];
    }
}

