/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.registries.entities.misc;

import com.li64.tide.registries.TideEntityTypes;
import com.li64.tide.registries.TideItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class DeepAquaArrow
extends AbstractArrow {
    public int lifetime = 50;
    private static final ItemStack DEFAULT_ARROW_STACK = new ItemStack((ItemLike)TideItems.DEEP_AQUA_ARROW);

    public DeepAquaArrow(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
    }

    public DeepAquaArrow(Level level, LivingEntity entity, ItemStack itemStack) {
        super(TideEntityTypes.DEEP_AQUA_ARROW, entity, level);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_20096_()) {
            Vec3 vel = this.m_20184_();
            double d5 = vel.f_82479_;
            double d6 = vel.f_82480_;
            double d1 = vel.f_82481_;
            for (int i = 0; i < 4; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_() + d5 * (double)i / 4.0, this.m_20186_() + d6 * (double)i / 4.0, this.m_20189_() + d1 * (double)i / 4.0, -d5, -d6 + 0.2, -d1);
            }
            if (!this.m_9236_().m_5776_()) {
                --this.lifetime;
                if (this.lifetime <= 0) {
                    this.playSplashParticles(this.m_20183_());
                    this.m_6074_();
                }
            }
        }
    }

    protected ItemStack m_7941_() {
        return DEFAULT_ARROW_STACK;
    }

    protected void m_6532_(HitResult hitResult) {
        HitResult.Type hitType = hitResult.m_6662_();
        if (hitType == HitResult.Type.ENTITY) {
            this.m_5790_((EntityHitResult)hitResult);
            this.m_9236_().m_214171_(GameEvent.f_157777_, hitResult.m_82450_(), GameEvent.Context.m_223719_((Entity)this, null));
            this.playSplashParticles(this.m_20183_());
        } else if (hitType == HitResult.Type.BLOCK) {
            BlockHitResult blockhitresult = (BlockHitResult)hitResult;
            this.m_8060_(blockhitresult);
            BlockPos blockpos = blockhitresult.m_82425_();
            this.playSplashParticles(blockpos);
            this.m_9236_().m_220407_(GameEvent.f_157777_, blockpos, GameEvent.Context.m_223719_((Entity)this, (BlockState)this.m_9236_().m_8055_(blockpos)));
            this.m_6074_();
        }
    }

    private void playSplashParticles(BlockPos pos) {
        for (int i = 0; i < 15; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123769_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.7, (double)pos.m_123343_() + 0.5, (double)(this.f_19796_.m_188501_() * 1.5f), 0.2, (double)(this.f_19796_.m_188501_() * 1.5f));
        }
    }

    @NotNull
    public Vec3 m_20184_() {
        if (this.m_36792_()) {
            return super.m_20184_().m_82541_().m_82490_(2.5);
        }
        return super.m_20184_().m_82541_().m_82490_((double)1.8f);
    }

    public boolean m_20068_() {
        return true;
    }

    public void m_20242_(boolean value) {
        super.m_20242_(false);
    }

    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)TideItems.DEEP_AQUA_ARROW);
    }
}

