/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.registries.items;

import com.li64.tide.Tide;
import com.li64.tide.client.gui.overlays.CastBarOverlay;
import com.li64.tide.data.minigame.FishCatchMinigame;
import com.li64.tide.data.rods.BobberModifier;
import com.li64.tide.data.rods.CustomRodManager;
import com.li64.tide.data.rods.HookModifier;
import com.li64.tide.data.rods.LineModifier;
import com.li64.tide.registries.TideEntityTypes;
import com.li64.tide.registries.entities.misc.fishing.HookAccessor;
import com.li64.tide.registries.entities.misc.fishing.TideFishingHook;
import com.li64.tide.util.TideUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class TideFishingRodItem
extends FishingRodItem {
    public static final ResourceLocation CAST_PROPERTY = Tide.resource("cast");

    public TideFishingRodItem(double baseDurability, Item.Properties properties) {
        super(properties.m_41503_((int)(baseDurability * (Tide.CONFIG == null ? 1.0 : Tide.CONFIG.general.rodDurabilityMultiplier))));
    }

    public boolean isLavaproof(ItemStack stack) {
        return CustomRodManager.getHook(stack).isLavaproof();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (this.isHookActive(player)) {
            TideFishingHook hook = this.getHook(player);
            if (!this.isMinigameActive(player) && Tide.CONFIG.general.doMinigame) {
                if (Tide.PLATFORM.isModLoaded("stardew_fishing")) {
                    if (hook.getCatchType() == TideFishingHook.CatchType.FISH || hook.getCatchType() == TideFishingHook.CatchType.ITEM) {
                        if (!level.m_5776_()) {
                            Tide.LOG.info("Starting stardew fishing minigame");
                            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11939_, SoundSource.NEUTRAL, 1.2f, 0.4f / (level.m_213780_().m_188501_() * 0.4f + 0.8f));
                            if (!Tide.PLATFORM.stardewStart((ServerPlayer)player, (HookAccessor)player.f_36083_, player.m_21120_(hand), List.of(hook.getHookedItem().m_7968_()))) {
                                this.retrieveHook(player.m_21120_(hand), player, level);
                            }
                        }
                    } else {
                        this.retrieveHook(player.m_21120_(hand), player, level);
                    }
                } else if (hook.getCatchType() == TideFishingHook.CatchType.FISH) {
                    if (!level.m_5776_() && !this.isMinigameActive(player)) {
                        Tide.LOG.info("Starting tide fishing minigame");
                        FishCatchMinigame.create(player);
                    }
                } else {
                    this.retrieveHook(player.m_21120_(hand), player, level);
                }
            } else if (!level.m_5776_()) {
                if (Tide.CONFIG.general.doMinigame) {
                    FishCatchMinigame minigame = FishCatchMinigame.getInstance(player);
                    if (minigame != null) {
                        minigame.interact();
                    }
                } else {
                    hook.retrieve();
                }
            }
            return InteractionResultHolder.m_19092_((Object)player.m_21120_(hand), (boolean)level.m_5776_());
        }
        if (Tide.CONFIG.general.holdToCast) {
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11939_, SoundSource.NEUTRAL, 1.5f, 0.3f / (level.m_213780_().m_188501_() * 0.4f + 0.7f));
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)player.m_21120_(hand));
        }
        this.castHook(player.m_21120_(hand), player, level, 1.0f);
        return InteractionResultHolder.m_19092_((Object)player.m_21120_(hand), (boolean)level.m_5776_());
    }

    private boolean isMinigameActive(Player player) {
        return FishCatchMinigame.minigameActive(player);
    }

    public void m_5551_(ItemStack rod, Level level, LivingEntity user, int charge) {
        if (user instanceof Player) {
            Player player = (Player)user;
            int chargeDifference = this.m_8105_(rod) - charge;
            if (chargeDifference > this.getChargeDuration(rod)) {
                chargeDifference = this.getChargeDuration(rod);
            }
            float chargeMultiplier = (float)chargeDifference / (float)this.getChargeDuration(rod) + 0.5f;
            this.castHook(rod, player, level, chargeMultiplier);
        }
    }

    public boolean isHookActive(Player player) {
        TideFishingHook hook = HookAccessor.getHook(player);
        return hook != null;
    }

    public TideFishingHook getHook(Player player) {
        return HookAccessor.getHook(player);
    }

    public void castHook(ItemStack rod, Player player, Level level, float charge) {
        TideFishingHook activeHook = HookAccessor.getHook(player);
        if (activeHook == null) {
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11941_, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.m_213780_().m_188501_() * 0.4f + 0.8f));
            if (!level.f_46443_) {
                int speed = EnchantmentHelper.m_44916_((ItemStack)rod);
                int luck = EnchantmentHelper.m_44904_((ItemStack)rod);
                if (TideUtils.isHoldingBait(player)) {
                    speed += TideUtils.getBaitSpeed(TideUtils.getHeldBaitItem(player));
                    luck += TideUtils.getBaitLuck(TideUtils.getHeldBaitItem(player));
                }
                level.m_7967_((Entity)new TideFishingHook(TideEntityTypes.FISHING_BOBBER, player, level, luck, speed, charge, rod));
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            player.m_146850_(GameEvent.f_223698_);
        }
    }

    public void retrieveHook(ItemStack rod, Player player, Level level) {
        TideFishingHook activeHook = HookAccessor.getHook(player);
        if (activeHook != null) {
            if (!level.f_46443_) {
                int durabilityLoss = activeHook.retrieve(rod, (ServerLevel)level, player);
                rod.m_41622_(durabilityLoss, (LivingEntity)player, playerTemp -> playerTemp.m_21190_(player.m_7655_()));
            }
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11939_, SoundSource.NEUTRAL, 1.2f, 0.4f / (level.m_213780_().m_188501_() * 0.4f + 0.8f));
            player.m_146850_(GameEvent.f_223697_);
        }
    }

    public void m_5929_(Level level, LivingEntity user, ItemStack rod, int charge) {
        super.m_5929_(level, user, rod, charge);
        if (level.m_5776_() && user == Minecraft.m_91087_().f_91074_) {
            int chargeDifference = this.m_8105_(rod) - charge;
            if (chargeDifference > this.getChargeDuration(rod)) {
                chargeDifference = this.getChargeDuration(rod);
            }
            CastBarOverlay.rodChargeTick((float)chargeDifference / (float)this.getChargeDuration(rod));
        }
    }

    public int m_8105_(ItemStack stack) {
        return 60000;
    }

    public int getChargeDuration(ItemStack rod) {
        return CustomRodManager.getLine(rod) == LineModifier.BRAIDED ? 15 : 25;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        BobberModifier bobber = CustomRodManager.getBobber(stack);
        HookModifier hook = CustomRodManager.getHook(stack);
        LineModifier line = CustomRodManager.getLine(stack);
        MutableComponent bobberComponent = Component.m_237115_((String)bobber.getTranslationKey());
        tooltip.add((Component)bobberComponent.m_130948_(bobberComponent.m_7383_().m_131155_(Boolean.valueOf(true)).m_131140_(ChatFormatting.YELLOW)));
        MutableComponent hookComponent = Component.m_237115_((String)hook.getTranslationKey());
        tooltip.add((Component)hookComponent.m_130948_(hookComponent.m_7383_().m_131155_(Boolean.valueOf(true)).m_131140_(ChatFormatting.YELLOW)));
        MutableComponent lineComponent = Component.m_237115_((String)line.getTranslationKey());
        tooltip.add((Component)lineComponent.m_130948_(lineComponent.m_7383_().m_131155_(Boolean.valueOf(true)).m_131140_(ChatFormatting.YELLOW)));
    }
}

