/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.util;

import com.li64.tide.Tide;
import com.li64.tide.client.gui.JournalPage;
import com.li64.tide.data.TideCriteriaTriggers;
import com.li64.tide.data.TideLootTables;
import com.li64.tide.data.TideTags;
import com.li64.tide.data.journal.JournalLayout;
import com.li64.tide.data.player.TidePlayerData;
import com.li64.tide.network.messages.ShowToastMsg;
import com.li64.tide.registries.TideItems;
import com.li64.tide.registries.entities.misc.fishing.TideFishingHook;
import com.li64.tide.registries.items.BaitItem;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

public class TideUtils {
    private static HashMap<String, Item> profileItems;

    public static boolean moddedDimension(ResourceKey<Level> dimension) {
        return dimension != Level.f_46428_ && dimension != Level.f_46429_ && dimension != Level.f_46430_;
    }

    public static LootLayer getLayerAt(double y) {
        if (y < 0.0) {
            return LootLayer.DEPTHS;
        }
        if (y < 50.0) {
            return LootLayer.UNDERGROUND;
        }
        return LootLayer.SURFACE;
    }

    public static List<ItemStack> checkForOverrides(List<ItemStack> list, TideFishingHook hook, ServerLevel level) {
        ItemStack result = list.get(0);
        int luck = hook.getLuck();
        int moonPhase = level.m_46941_();
        if (result.m_150930_(TideItems.VOIDSEEKER) && moonPhase != 0 && moonPhase != 4) {
            result = new ItemStack((ItemLike)TideItems.ENDSTONE_PERCH, 1);
        }
        if (hook.getLuck() >= 5 && new Random().nextInt(0, 24) == 1) {
            result = new ItemStack((ItemLike)TideItems.MIDAS_FISH, 1);
        }
        if (moonPhase == 0 && hook.getBiome().m_203656_(TideTags.Biomes.CAN_CATCH_STARFISH) && level.m_46462_() && new Random().nextInt(0, 24 - luck) == 1) {
            result = new ItemStack((ItemLike)TideItems.SHOOTING_STARFISH, 1);
        }
        return List.of(result);
    }

    public static boolean shouldGrabTideLootTable(List<ItemStack> items, FluidState fluid) {
        if (items.get(0).m_204117_(TideTags.Items.VANILLA_FISH) || new Random().nextInt(0, 4) == 0) {
            return true;
        }
        return fluid.m_205070_(TideTags.Fluids.LAVA_FISHING);
    }

    private static boolean isInDimension(String name, Level level) {
        return level.m_46472_().m_135782_().toString().matches(name);
    }

    public static ResourceLocation getTideLootTable(double x, double y, double z, FluidState fluid, Level level, RandomSource random) {
        LootLayer layer = TideUtils.getLayerAt(y);
        Holder biomeHolder = level.m_204166_(new BlockPos((int)x, (int)y, (int)z));
        if (TideUtils.moddedDimension((ResourceKey<Level>)level.m_46472_())) {
            if (fluid.m_205070_(TideTags.Fluids.LAVA_FISHING)) {
                return TideLootTables.Fishing.LAVA_SURFACE;
            }
            return BuiltInLootTables.f_78720_;
        }
        if (level.m_46472_() == Level.f_46429_) {
            if (Tide.PLATFORM.isModLoaded("netherdepthsupgrade")) {
                Random random2 = new Random();
                if (random2.nextFloat() > 0.65f) {
                    return new ResourceLocation("netherdepthsupgrade", "gameplay/nether_fishing");
                }
            }
            return TideLootTables.Fishing.NETHER;
        }
        if (level.m_46472_() == Level.f_46430_) {
            if (fluid.m_205070_(TideTags.Fluids.LAVA_FISHING)) {
                return TideLootTables.Fishing.END_LAVA;
            }
            return TideLootTables.Fishing.END_WATER;
        }
        if (layer == LootLayer.UNDERGROUND && level.m_46472_() == Level.f_46428_) {
            if (fluid.m_205070_(TideTags.Fluids.LAVA_FISHING)) {
                return TideLootTables.Fishing.LAVA_UNDERGROUND;
            }
            ResourceLocation biomeLoot = TideUtils.getBiomeLootTable((Holder<Biome>)biomeHolder);
            if (biomeLoot != null && random.m_216339_(0, 21) == 1) {
                return biomeLoot;
            }
            return TideLootTables.Fishing.UNDERGROUND;
        }
        if (layer == LootLayer.DEPTHS && level.m_46472_() == Level.f_46428_) {
            if (fluid.m_205070_(TideTags.Fluids.LAVA_FISHING)) {
                return TideLootTables.Fishing.LAVA_DEPTHS;
            }
            ResourceLocation biomeLoot = TideUtils.getBiomeLootTable((Holder<Biome>)biomeHolder);
            if (biomeLoot != null && random.m_216339_(0, 21) == 1) {
                return biomeLoot;
            }
            return TideLootTables.Fishing.DEPTHS;
        }
        if (fluid.m_205070_(TideTags.Fluids.LAVA_FISHING)) {
            return TideLootTables.Fishing.LAVA_SURFACE;
        }
        ResourceLocation biomeLoot = TideUtils.getBiomeLootTable((Holder<Biome>)biomeHolder);
        if (biomeLoot != null && random.m_216339_(0, 21) == 1) {
            return biomeLoot;
        }
        if (biomeHolder.m_203656_(TideTags.Climate.IS_COLD)) {
            if (biomeHolder.m_203656_(TideTags.Climate.IS_SALTWATER)) {
                return TideLootTables.Fishing.SALTWATER_COLD;
            }
            return TideLootTables.Fishing.FRESHWATER_COLD;
        }
        if (biomeHolder.m_203656_(TideTags.Climate.IS_WARM)) {
            if (biomeHolder.m_203656_(TideTags.Climate.IS_SALTWATER)) {
                return TideLootTables.Fishing.SALTWATER_WARM;
            }
            return TideLootTables.Fishing.FRESHWATER_WARM;
        }
        if (biomeHolder.m_203656_(TideTags.Climate.IS_SALTWATER)) {
            return TideLootTables.Fishing.SALTWATER_NORMAL;
        }
        return TideLootTables.Fishing.FRESHWATER_NORMAL;
    }

    public static ResourceLocation getBiomeLootTable(Holder<Biome> biomeHolder) {
        for (TagKey<Biome> tag : TideTags.Biomes.fishingBiomes) {
            if (!biomeHolder.m_203656_(tag)) continue;
            return Tide.resource("gameplay/fishing/biomes/" + tag.f_203868_().m_135815_());
        }
        return null;
    }

    public static ResourceLocation getCrateLoot(double x, double y, double z, FluidState fluid, Level level) {
        Holder biomeHolder = level.m_204166_(new BlockPos((int)x, (int)y, (int)z));
        LootLayer layer = TideUtils.getLayerAt(y);
        if (fluid.m_76152_() == Fluids.f_76195_) {
            if (level.m_46472_() == Level.f_46429_) {
                return TideLootTables.Crates.NETHER_LAVA;
            }
            if (level.m_46472_() == Level.f_46430_) {
                return TideLootTables.Crates.END_LAVA;
            }
            if (layer == LootLayer.SURFACE) {
                return TideLootTables.Crates.OVERWORLD_LAVA_SURFACE;
            }
            if (layer == LootLayer.UNDERGROUND) {
                return TideLootTables.Crates.OVERWORLD_LAVA_UNDERGROUND;
            }
            return TideLootTables.Crates.OVERWORLD_LAVA_DEEP;
        }
        if (level.m_46472_() == Level.f_46430_) {
            return TideLootTables.Crates.END_WATER;
        }
        if (layer == LootLayer.SURFACE) {
            if (biomeHolder.m_203656_(TideTags.Climate.IS_SALTWATER)) {
                return TideLootTables.Crates.OVERWORLD_WATER_OCEAN;
            }
            return TideLootTables.Crates.OVERWORLD_WATER_RIVER;
        }
        if (layer == LootLayer.UNDERGROUND) {
            return TideLootTables.Crates.OVERWORLD_WATER_UNDERGROUND;
        }
        return TideLootTables.Crates.OVERWORLD_WATER_DEEP;
    }

    public static boolean isJournalFish(ItemStack stack) {
        if (profileItems == null || profileItems.size() < Tide.JOURNAL.getProfileConfigs().size()) {
            profileItems = new HashMap();
            Tide.JOURNAL.getProfileConfigs().forEach(config -> profileItems.put(config.fishItem(), TideUtils.getItemFromName(config.fishItem())));
        }
        return profileItems.containsKey(TideUtils.getNameFromItem(stack.m_41720_()));
    }

    public static String getNameFromItem(Item item) {
        return BuiltInRegistries.f_257033_.m_7981_((Object)item).toString();
    }

    public static Item getItemFromName(String name) {
        return (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(name));
    }

    public static void checkPageCompletion(TidePlayerData data, JournalPage page, ServerPlayer player) {
        if (TideUtils.isCategoryCompleted(data, page) && !data.hasPageCompleted(page)) {
            data.pagesCompleted.add(page.id());
            if (data.pagesCompleted.size() <= 1) {
                TideCriteriaTriggers.FINISH_PAGE.trigger(player);
            }
            if (data.pagesCompleted.size() >= Tide.JOURNAL.getPageConfigs().size() - 1) {
                data.finishedJournal = true;
                TideCriteriaTriggers.FINISH_JOURNAL.trigger(player);
            }
            data.syncTo(player);
            Tide.LOG.debug("Player completed category: {}", (Object)page.idName());
            Tide.LOG.debug("Completed {}/{} categories", (Object)data.pagesCompleted.size(), (Object)Tide.JOURNAL.getPageConfigs().size());
        }
    }

    public static boolean isCategoryCompleted(TidePlayerData data, JournalPage page) {
        List<Item> fishes = TideUtils.getFishFromProfileList(page.getAllProfiles());
        if (fishes == null) {
            return false;
        }
        for (Item fish : fishes) {
            ItemStack fishStack = new ItemStack((ItemLike)fish);
            if (data.hasFishUnlocked(fishStack)) continue;
            return false;
        }
        return true;
    }

    public static void unlockPage(ServerPlayer player, JournalPage page) {
        TidePlayerData data = TidePlayerData.getOrCreate(player);
        if (!data.hasPageUnlocked(page)) {
            data.unlockPage(page);
            Tide.NETWORK.sendToPlayer(new ShowToastMsg((Component)Component.m_237115_((String)"newpage.toast.title"), TideUtils.getPageToastDesc(page), TideUtils.getPageToastIcon(page)), player);
            data.syncTo(player);
        }
    }

    public static void unlockFishForCategory(ServerPlayer player, String name) {
        TidePlayerData data = TidePlayerData.getOrCreate(player);
        JournalPage page = TideUtils.getPageByName(name);
        if (page == null) {
            return;
        }
        List<Item> fishes = TideUtils.getFishFromProfileList(page.getAllProfiles());
        for (Item fish : fishes) {
            if (data.hasFishUnlocked(fish.m_7968_())) continue;
            data.unlockFish(fish.m_7968_());
        }
        TideUtils.checkPageCompletion(data, page, player);
        data.syncTo(player);
    }

    public static boolean isInPage(String pageName, ItemStack stack) {
        List<Item> fishes = TideUtils.getFishFromPageName(pageName);
        if (fishes == null) {
            return false;
        }
        return fishes.contains(stack.m_41720_());
    }

    public static Component removeRawTextInName(Component initialName) {
        String[] splitName = Component.m_237115_((String)initialName.getString()).getString().split("Raw ");
        StringBuilder nameBuilder = new StringBuilder();
        for (String string : splitName) {
            nameBuilder.append(string);
        }
        return Component.m_237113_((String)nameBuilder.toString());
    }

    public static ItemStack getPageToastIcon(JournalPage page) {
        return page.icon();
    }

    public static Component getPageToastDesc(JournalPage page) {
        return Component.m_237115_((String)page.title());
    }

    public static List<Item> getFishFromProfileList(List<JournalLayout.Profile> profiles) {
        return profiles.stream().map(profile -> (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(profile.fishItem()))).toList();
    }

    public static List<Item> getFishFromPageName(String name) {
        JournalPage page = TideUtils.getPageByName(name);
        if (page == null) {
            return null;
        }
        return TideUtils.getFishFromProfileList(page.getAllProfiles());
    }

    public static JournalPage getPageByName(String name) {
        JournalLayout.Page pageConfig = Tide.JOURNAL.getPageConfigs().stream().filter(config -> config.id().matches(name)).findFirst().orElse(null);
        if (pageConfig == null) {
            return null;
        }
        return new JournalPage(pageConfig);
    }

    public static JournalPage getPageByNumber(int pageNumber) {
        if (pageNumber > Tide.JOURNAL.getPageConfigs().size() - 1) {
            return null;
        }
        return new JournalPage(Tide.JOURNAL.getPageConfigs().get(pageNumber));
    }

    public static JournalLayout.Profile getProfileFromItem(ItemStack item) {
        return Tide.JOURNAL.getProfileConfigs().stream().filter(config -> item.m_150930_((Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(config.fishItem())))).findFirst().orElse(null);
    }

    public static boolean isHoldingBait(Player player) {
        return TideUtils.isBait(player.m_21206_()) || TideUtils.isBait(player.m_21205_());
    }

    public static ItemStack getHeldBaitItem(Player player) {
        if (!TideUtils.isHoldingBait(player)) {
            return ItemStack.f_41583_;
        }
        return TideUtils.isBait(player.m_21206_()) ? player.m_21206_() : player.m_21205_();
    }

    public static boolean isBait(ItemStack stack) {
        if (stack.m_41778_().equals("item.fishofthieves.earthworms")) {
            return true;
        }
        if (stack.m_41778_().equals("item.fishofthieves.grubs")) {
            return true;
        }
        if (stack.m_41778_().equals("item.fishofthieves.leeches")) {
            return true;
        }
        return stack.m_41720_() instanceof BaitItem;
    }

    public static int getBaitSpeed(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof BaitItem) {
            BaitItem bait = (BaitItem)item;
            return bait.getSpeedBonus();
        }
        if (stack.m_41778_().equals("item.fishofthieves.earthworms")) {
            return 2;
        }
        if (stack.m_41778_().equals("item.fishofthieves.grubs")) {
            return 2;
        }
        if (stack.m_41778_().equals("item.fishofthieves.leeches")) {
            return 2;
        }
        return 0;
    }

    public static int getBaitLuck(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof BaitItem) {
            BaitItem bait = (BaitItem)item;
            return bait.getLuckBonus();
        }
        return 0;
    }

    public static enum LootLayer {
        SURFACE,
        UNDERGROUND,
        DEPTHS;

    }
}

