/*
 * Decompiled with CFR 0.152.
 */
package com.craisinlord.integrated_api.world.structures.placements;

import com.craisinlord.integrated_api.modinit.IAStructurePlacementType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.Vec3i;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;

public class StrongholdPlacement
extends RandomSpreadStructurePlacement {
    public static final Codec<StrongholdPlacement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Vec3i.m_194650_((int)16).optionalFieldOf("locate_offset", (Object)Vec3i.f_123288_).forGetter(rec$ -> ((StrongholdPlacement)((Object)((Object)((Object)rec$)))).m_227072_()), (App)StructurePlacement.FrequencyReductionMethod.f_227108_.optionalFieldOf("frequency_reduction_method", (Object)StructurePlacement.FrequencyReductionMethod.DEFAULT).forGetter(rec$ -> ((StrongholdPlacement)((Object)((Object)((Object)rec$)))).m_227073_()), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("frequency", (Object)Float.valueOf(1.0f)).forGetter(rec$ -> Float.valueOf(((StrongholdPlacement)((Object)((Object)((Object)rec$)))).m_227074_())), (App)ExtraCodecs.f_144628_.fieldOf("salt").forGetter(rec$ -> ((StrongholdPlacement)((Object)((Object)((Object)rec$)))).m_227075_()), (App)StructurePlacement.ExclusionZone.f_227077_.optionalFieldOf("exclusion_zone").forGetter(rec$ -> ((StrongholdPlacement)((Object)((Object)((Object)rec$)))).m_227076_()), (App)ExtraCodecs.f_144628_.fieldOf("spacing").forGetter(RandomSpreadStructurePlacement::m_205003_), (App)ExtraCodecs.f_144628_.fieldOf("separation").forGetter(RandomSpreadStructurePlacement::m_205004_), (App)RandomSpreadType.f_205014_.optionalFieldOf("spread_type", (Object)RandomSpreadType.LINEAR).forGetter(RandomSpreadStructurePlacement::m_205005_), (App)ExtraCodecs.f_144628_.fieldOf("chunk_distance_to_first_ring").forGetter(StrongholdPlacement::chunkDistanceToFirstRing), (App)ExtraCodecs.f_144628_.fieldOf("ring_chunk_thickness").forGetter(StrongholdPlacement::ringChunkThickness), (App)ExtraCodecs.f_144628_.optionalFieldOf("max_ring_section").forGetter(StrongholdPlacement::maxRingSection)).apply((Applicative)instance, instance.stable(StrongholdPlacement::new)));
    private final int chunkDistanceToFirstRing;
    private final int ringChunkThickness;
    private final Optional<Integer> maxRingSection;

    public StrongholdPlacement(Vec3i locateOffset, StructurePlacement.FrequencyReductionMethod frequencyReductionMethod, Float frequency, Integer salt, Optional<StructurePlacement.ExclusionZone> exclusionZone, Integer spacing, Integer separation, RandomSpreadType randomSpreadType, Integer chunkDistanceToFirstRing, Integer ringChunkThickness, Optional<Integer> maxRingSection) {
        super(locateOffset, frequencyReductionMethod, frequency.floatValue(), salt.intValue(), exclusionZone, spacing.intValue(), separation.intValue(), randomSpreadType);
        this.chunkDistanceToFirstRing = chunkDistanceToFirstRing;
        this.ringChunkThickness = ringChunkThickness;
        this.maxRingSection = maxRingSection;
    }

    protected boolean m_214090_(ChunkGeneratorStructureState chunkGeneratorStructureState, int chunkX, int chunkZ) {
        long seed = chunkGeneratorStructureState.m_254887_();
        ChunkPos chunkPos = this.m_227008_(seed, chunkX, chunkZ);
        if (chunkPos.f_45578_ == chunkX && chunkPos.f_45579_ == chunkZ) {
            int chunkDistance = (int)Math.sqrt(chunkX * chunkX + chunkZ * chunkZ);
            int shiftedChunkDistance = chunkDistance + (this.ringChunkThickness - this.chunkDistanceToFirstRing);
            int ringSection = shiftedChunkDistance / this.ringChunkThickness;
            if (this.maxRingSection.isPresent() && ringSection > this.maxRingSection.get()) {
                return false;
            }
            return ringSection % 2 == 1;
        }
        return false;
    }

    public StructurePlacementType<?> m_203443_() {
        return (StructurePlacementType)IAStructurePlacementType.STRONGHOLD_PLACEMENT;
    }

    public int chunkDistanceToFirstRing() {
        return this.chunkDistanceToFirstRing;
    }

    public int ringChunkThickness() {
        return this.ringChunkThickness;
    }

    public Optional<Integer> maxRingSection() {
        return this.maxRingSection;
    }
}

